/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorStatusManager;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;

@DriverSide
@Private
public final class EvaluatorControlHandler {
    private static Logger LOG = Logger.getLogger(EvaluatorControlHandler.class.getName());
    private final EvaluatorStatusManager stateManager;
    private final RemoteManager remoteManager;
    private final String evaluatorId;
    private Optional<EventHandler<EvaluatorRuntimeProtocol.EvaluatorControlProto>> wrapped = Optional.empty();

    @Inject
    EvaluatorControlHandler(EvaluatorStatusManager stateManager, RemoteManager remoteManager, @Parameter(value=EvaluatorManager.EvaluatorIdentifier.class) String evaluatorId) {
        this.stateManager = stateManager;
        this.remoteManager = remoteManager;
        this.evaluatorId = evaluatorId;
        LOG.log(Level.FINE, "Instantiated 'EvaluatorControlHandler'");
    }

    public synchronized void send(EvaluatorRuntimeProtocol.EvaluatorControlProto evaluatorControlProto) {
        if (!this.wrapped.isPresent()) {
            throw new IllegalStateException("Trying to send an EvaluatorControlProto before the Evaluator ID is set.");
        }
        if (!this.stateManager.isRunning()) {
            LOG.log(Level.WARNING, "Trying to send an EvaluatorControlProto to Evaluator [{0}] that is in state [{1}], not [RUNNING]. The control message was: {2}", new Object[]{this.evaluatorId, this.stateManager, evaluatorControlProto});
            return;
        }
        ((EventHandler)this.wrapped.get()).onNext((Object)evaluatorControlProto);
    }

    synchronized void setRemoteID(String evaluatorRID) {
        if (this.wrapped.isPresent()) {
            throw new IllegalStateException("Trying to reset the evaluator ID. This isn't supported.");
        }
        LOG.log(Level.FINE, "Registering remoteId [{0}] for Evaluator [{1}]", new Object[]{evaluatorRID, this.evaluatorId});
        this.wrapped = Optional.of(this.remoteManager.getHandler(evaluatorRID, EvaluatorRuntimeProtocol.EvaluatorControlProto.class));
    }
}

