/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.driver.evaluator.EvaluatorType;
import org.apache.reef.runtime.common.driver.api.ResourceLaunchEventImpl;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.evaluator.EvaluatorConfiguration;
import org.apache.reef.runtime.common.files.FileResourceImpl;
import org.apache.reef.runtime.common.files.FileType;
import org.apache.reef.runtime.common.launch.ProcessType;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.ConfigurationProvider;
import org.apache.reef.tang.JavaConfigurationBuilder;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.ConfigurationModule;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.Optional;
import org.apache.reef.util.logging.LoggingScope;
import org.apache.reef.util.logging.LoggingScopeFactory;

@DriverSide
@Private
final class AllocatedEvaluatorImpl
implements AllocatedEvaluator {
    private static final Logger LOG = Logger.getLogger(AllocatedEvaluatorImpl.class.getName());
    private final EvaluatorManager evaluatorManager;
    private final String remoteID;
    private final ConfigurationSerializer configurationSerializer;
    private final String jobIdentifier;
    private final LoggingScopeFactory loggingScopeFactory;
    private final Set<ConfigurationProvider> evaluatorConfigurationProviders;
    private final Collection<File> files = new HashSet<File>();
    private final Collection<File> libraries = new HashSet<File>();

    AllocatedEvaluatorImpl(EvaluatorManager evaluatorManager, String remoteID, ConfigurationSerializer configurationSerializer, String jobIdentifier, LoggingScopeFactory loggingScopeFactory, Set<ConfigurationProvider> evaluatorConfigurationProviders) {
        this.evaluatorManager = evaluatorManager;
        this.remoteID = remoteID;
        this.configurationSerializer = configurationSerializer;
        this.jobIdentifier = jobIdentifier;
        this.loggingScopeFactory = loggingScopeFactory;
        this.evaluatorConfigurationProviders = evaluatorConfigurationProviders;
    }

    @Override
    public String getId() {
        return this.evaluatorManager.getId();
    }

    @Override
    public void close() {
        this.evaluatorManager.close();
    }

    @Override
    public void submitTask(Configuration taskConfiguration) {
        Configuration contextConfiguration = ContextConfiguration.CONF.set(ContextConfiguration.IDENTIFIER, "RootContext_" + this.getId()).build();
        this.submitContextAndTask(contextConfiguration, taskConfiguration);
    }

    @Override
    public EvaluatorDescriptor getEvaluatorDescriptor() {
        return this.evaluatorManager.getEvaluatorDescriptor();
    }

    @Override
    public void submitContext(Configuration contextConfiguration) {
        this.launch(contextConfiguration, (Optional<Configuration>)Optional.empty(), (Optional<Configuration>)Optional.empty());
    }

    @Override
    public void submitContextAndService(Configuration contextConfiguration, Configuration serviceConfiguration) {
        this.launch(contextConfiguration, (Optional<Configuration>)Optional.of((Object)serviceConfiguration), (Optional<Configuration>)Optional.empty());
    }

    @Override
    public void submitContextAndTask(Configuration contextConfiguration, Configuration taskConfiguration) {
        this.launch(contextConfiguration, (Optional<Configuration>)Optional.empty(), (Optional<Configuration>)Optional.of((Object)taskConfiguration));
    }

    @Override
    public void submitContextAndServiceAndTask(Configuration contextConfiguration, Configuration serviceConfiguration, Configuration taskConfiguration) {
        this.launch(contextConfiguration, (Optional<Configuration>)Optional.of((Object)serviceConfiguration), (Optional<Configuration>)Optional.of((Object)taskConfiguration));
    }

    @Override
    public void setType(EvaluatorType type) {
        this.evaluatorManager.setType(type);
    }

    @Override
    public void addFile(File file) {
        this.files.add(file);
    }

    @Override
    public void addLibrary(File file) {
        this.libraries.add(file);
    }

    private final void launch(Configuration contextConfiguration, Optional<Configuration> serviceConfiguration, Optional<Configuration> taskConfiguration) {
        try (LoggingScope lb = this.loggingScopeFactory.evaluatorLaunch(this.getId());){
            try {
                Configuration evaluatorConfiguration;
                ConfigurationModule contextConfigurationModule;
                Configuration rootContextConfiguration = this.makeRootContextConfiguration(contextConfiguration);
                ConfigurationModule evaluatorConfigurationModule = EvaluatorConfiguration.CONF.set(EvaluatorConfiguration.APPLICATION_IDENTIFIER, this.jobIdentifier).set(EvaluatorConfiguration.DRIVER_REMOTE_IDENTIFIER, this.remoteID).set(EvaluatorConfiguration.EVALUATOR_IDENTIFIER, this.getId());
                String encodedContextConfigurationString = this.configurationSerializer.toString(rootContextConfiguration);
                if (serviceConfiguration.isPresent()) {
                    String encodedServiceConfigurationString = this.configurationSerializer.toString((Configuration)serviceConfiguration.get());
                    contextConfigurationModule = evaluatorConfigurationModule.set(EvaluatorConfiguration.ROOT_SERVICE_CONFIGURATION, encodedServiceConfigurationString).set(EvaluatorConfiguration.ROOT_CONTEXT_CONFIGURATION, encodedContextConfigurationString);
                } else {
                    contextConfigurationModule = evaluatorConfigurationModule.set(EvaluatorConfiguration.ROOT_CONTEXT_CONFIGURATION, encodedContextConfigurationString);
                }
                if (taskConfiguration.isPresent()) {
                    String encodedTaskConfigurationString = this.configurationSerializer.toString((Configuration)taskConfiguration.get());
                    evaluatorConfiguration = contextConfigurationModule.set(EvaluatorConfiguration.TASK_CONFIGURATION, encodedTaskConfigurationString).build();
                } else {
                    evaluatorConfiguration = contextConfigurationModule.build();
                }
                ResourceLaunchEventImpl.Builder rbuilder = ResourceLaunchEventImpl.newBuilder().setIdentifier(this.evaluatorManager.getId()).setRemoteId(this.remoteID).setEvaluatorConf(evaluatorConfiguration);
                for (File file : this.files) {
                    rbuilder.addFile(FileResourceImpl.newBuilder().setName(file.getName()).setPath(file.getPath()).setType(FileType.PLAIN).build());
                }
                for (File lib : this.libraries) {
                    rbuilder.addFile(FileResourceImpl.newBuilder().setName(lib.getName()).setPath(lib.getPath().toString()).setType(FileType.LIB).build());
                }
                switch (this.evaluatorManager.getEvaluatorDescriptor().getType()) {
                    case CLR: {
                        rbuilder.setType(ProcessType.CLR);
                        break;
                    }
                    default: {
                        rbuilder.setType(ProcessType.JVM);
                    }
                }
                this.evaluatorManager.onResourceLaunch(rbuilder.build());
            }
            catch (BindException ex) {
                LOG.log(Level.SEVERE, "Bad Evaluator configuration", ex);
                throw new RuntimeException("Bad Evaluator configuration", ex);
            }
        }
    }

    private Configuration makeRootContextConfiguration(Configuration contextConfiguration) {
        EvaluatorType evaluatorType = this.evaluatorManager.getEvaluatorDescriptor().getType();
        if (EvaluatorType.JVM != evaluatorType) {
            LOG.log(Level.FINE, "Not using the ConfigurationProviders as we are configuring a {0} Evaluator.", (Object)evaluatorType);
            return contextConfiguration;
        }
        JavaConfigurationBuilder configurationBuilder = Tang.Factory.getTang().newConfigurationBuilder(new Configuration[]{contextConfiguration});
        for (ConfigurationProvider configurationProvider : this.evaluatorConfigurationProviders) {
            configurationBuilder.addConfiguration(configurationProvider.getConfiguration());
        }
        return configurationBuilder.build();
    }

    public String toString() {
        return "AllocatedEvaluator{ID='" + this.getId() + "'}";
    }
}

