/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.context;

import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.common.AbstractFailure;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.FailedContext;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.util.Optional;

@Private
@DriverSide
public final class FailedContextImpl
extends AbstractFailure
implements FailedContext {
    private final Optional<ActiveContext> parentContext;
    private final EvaluatorDescriptor evaluatorDescriptor;
    private final String evaluatorID;

    public FailedContextImpl(String id, String message, Optional<String> description, Optional<Throwable> cause, Optional<byte[]> data, Optional<ActiveContext> parentContext, EvaluatorDescriptor evaluatorDescriptor, String evaluatorID) {
        super(id, message, description, cause, data);
        this.parentContext = parentContext;
        this.evaluatorDescriptor = evaluatorDescriptor;
        this.evaluatorID = evaluatorID;
    }

    @Override
    public Optional<ActiveContext> getParentContext() {
        return this.parentContext;
    }

    @Override
    public String getEvaluatorId() {
        return this.evaluatorID;
    }

    @Override
    public Optional<String> getParentId() {
        if (this.getParentContext().isPresent()) {
            return Optional.of((Object)((ActiveContext)this.getParentContext().get()).getId());
        }
        return Optional.empty();
    }

    @Override
    public EvaluatorDescriptor getEvaluatorDescriptor() {
        return this.evaluatorDescriptor;
    }

    @Override
    public String toString() {
        return "FailedContext{evaluatorID='" + this.evaluatorID + "', contextID='" + this.getId() + "'}";
    }
}

