/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.context;

import com.google.protobuf.ByteString;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.ClosedContext;
import org.apache.reef.driver.context.FailedContext;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.context.ClosedContextImpl;
import org.apache.reef.runtime.common.driver.context.ContextControlHandler;
import org.apache.reef.runtime.common.driver.context.ContextRepresenters;
import org.apache.reef.runtime.common.driver.context.FailedContextImpl;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorMessageDispatcher;
import org.apache.reef.runtime.common.utils.ExceptionCodec;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.Optional;

@DriverSide
@Private
public final class EvaluatorContext
implements ActiveContext {
    private static final Logger LOG = Logger.getLogger(EvaluatorContext.class.getName());
    private final String contextIdentifier;
    private final String evaluatorIdentifier;
    private final EvaluatorDescriptor evaluatorDescriptor;
    private final Optional<String> parentID;
    private final ConfigurationSerializer configurationSerializer;
    private final ContextControlHandler contextControlHandler;
    private final ExceptionCodec exceptionCodec;
    private final ContextRepresenters contextRepresenters;
    private boolean isClosed = false;

    public EvaluatorContext(String contextIdentifier, String evaluatorIdentifier, EvaluatorDescriptor evaluatorDescriptor, Optional<String> parentID, ConfigurationSerializer configurationSerializer, ContextControlHandler contextControlHandler, EvaluatorMessageDispatcher messageDispatcher, ExceptionCodec exceptionCodec, ContextRepresenters contextRepresenters) {
        this.contextIdentifier = contextIdentifier;
        this.evaluatorIdentifier = evaluatorIdentifier;
        this.evaluatorDescriptor = evaluatorDescriptor;
        this.parentID = parentID;
        this.configurationSerializer = configurationSerializer;
        this.contextControlHandler = contextControlHandler;
        this.exceptionCodec = exceptionCodec;
        this.contextRepresenters = contextRepresenters;
        LOG.log(Level.FINE, "Instantiated 'EvaluatorContext'");
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            throw new RuntimeException("Active context already closed");
        }
        LOG.log(Level.FINEST, "Submit close context: RunningEvaluator id[{0}] for context id[{1}]", new Object[]{this.getEvaluatorId(), this.getId()});
        EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setRemoveContext(EvaluatorRuntimeProtocol.RemoveContextProto.newBuilder().setContextId(this.getId()).build()).build();
        this.contextControlHandler.send(contextControlProto);
        this.isClosed = true;
    }

    @Override
    public synchronized void sendMessage(byte[] message) {
        if (this.isClosed) {
            throw new RuntimeException("Active context already closed");
        }
        LOG.log(Level.FINEST, "Send message: RunningEvaluator id[{0}] for context id[{1}]", new Object[]{this.getEvaluatorId(), this.getId()});
        EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setContextMessage(EvaluatorRuntimeProtocol.ContextMessageProto.newBuilder().setContextId(this.contextIdentifier).setMessage(ByteString.copyFrom((byte[])message)).build()).build();
        this.contextControlHandler.send(contextControlProto);
    }

    @Override
    public synchronized void submitTask(Configuration taskConf) {
        if (this.isClosed) {
            throw new RuntimeException("Active context already closed");
        }
        LOG.log(Level.FINEST, "Submit task: RunningEvaluator id[{0}] for context id[{1}]", new Object[]{this.getEvaluatorId(), this.getId()});
        EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setStartTask(EvaluatorRuntimeProtocol.StartTaskProto.newBuilder().setContextId(this.contextIdentifier).setConfiguration(this.configurationSerializer.toString(taskConf)).build()).build();
        this.contextControlHandler.send(contextControlProto);
    }

    @Override
    public synchronized void submitContext(Configuration contextConfiguration) {
        if (this.isClosed) {
            throw new RuntimeException("Active context already closed");
        }
        LOG.log(Level.FINEST, "Submit new context: RunningEvaluator id[{0}] for context id[{1}]", new Object[]{this.getEvaluatorId(), this.getId()});
        EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setAddContext(EvaluatorRuntimeProtocol.AddContextProto.newBuilder().setParentContextId(this.getId()).setContextConfiguration(this.configurationSerializer.toString(contextConfiguration)).build()).build();
        this.contextControlHandler.send(contextControlProto);
    }

    @Override
    public synchronized void submitContextAndService(Configuration contextConfiguration, Configuration serviceConfiguration) {
        if (this.isClosed) {
            throw new RuntimeException("Active context already closed");
        }
        LOG.log(Level.FINEST, "Submit new context: RunningEvaluator id[{0}] for context id[{1}]", new Object[]{this.getEvaluatorId(), this.getId()});
        EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setAddContext(EvaluatorRuntimeProtocol.AddContextProto.newBuilder().setParentContextId(this.getId()).setContextConfiguration(this.configurationSerializer.toString(contextConfiguration)).setServiceConfiguration(this.configurationSerializer.toString(serviceConfiguration)).build()).build();
        this.contextControlHandler.send(contextControlProto);
    }

    @Override
    public String getEvaluatorId() {
        return this.evaluatorIdentifier;
    }

    @Override
    public Optional<String> getParentId() {
        return this.parentID;
    }

    @Override
    public EvaluatorDescriptor getEvaluatorDescriptor() {
        return this.evaluatorDescriptor;
    }

    @Override
    public String getId() {
        return this.contextIdentifier;
    }

    public String toString() {
        return "EvaluatorContext{contextIdentifier='" + this.contextIdentifier + '\'' + ", evaluatorIdentifier='" + this.evaluatorIdentifier + '\'' + ", parentID=" + this.parentID + '}';
    }

    public final synchronized ClosedContext getClosedContext(ActiveContext parentContext) {
        return new ClosedContextImpl(parentContext, this.getId(), this.getEvaluatorId(), this.getEvaluatorDescriptor());
    }

    public synchronized FailedContext getFailedContextForEvaluatorFailure() {
        String id = this.getId();
        Optional description = Optional.empty();
        Optional data = Optional.empty();
        Optional cause = Optional.empty();
        String message = "Evaluator Failure";
        Optional parentContext = this.getParentId().isPresent() ? Optional.of((Object)this.contextRepresenters.getContext((String)this.getParentId().get())) : Optional.empty();
        EvaluatorDescriptor evaluatorDescriptor = this.getEvaluatorDescriptor();
        String evaluatorID = this.getEvaluatorId();
        return new FailedContextImpl(id, "Evaluator Failure", (Optional<String>)description, (Optional<Throwable>)cause, (Optional<byte[]>)data, (Optional<ActiveContext>)parentContext, evaluatorDescriptor, evaluatorID);
    }

    public synchronized FailedContext getFailedContext(ReefServiceProtos.ContextStatusProto contextStatusProto) {
        assert (ReefServiceProtos.ContextStatusProto.State.FAIL == contextStatusProto.getContextState());
        String id = this.getId();
        Optional description = Optional.empty();
        Optional data = contextStatusProto.hasError() ? Optional.of((Object)contextStatusProto.getError().toByteArray()) : Optional.empty();
        Optional<Throwable> cause = data.isPresent() ? this.exceptionCodec.fromBytes((Optional<byte[]>)data) : Optional.empty();
        String message = cause.isPresent() ? ((Throwable)cause.get()).getMessage() : "No message given";
        Optional parentContext = this.getParentId().isPresent() ? Optional.of((Object)this.contextRepresenters.getContext((String)this.getParentId().get())) : Optional.empty();
        EvaluatorDescriptor evaluatorDescriptor = this.getEvaluatorDescriptor();
        String evaluatorID = this.getEvaluatorId();
        return new FailedContextImpl(id, message, (Optional<String>)description, cause, (Optional<byte[]>)data, (Optional<ActiveContext>)parentContext, evaluatorDescriptor, evaluatorID);
    }

    public synchronized boolean isRootContext() {
        return !this.parentID.isPresent();
    }
}

