/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.context.FailedContext;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.context.ContextFactory;
import org.apache.reef.runtime.common.driver.context.ContextMessageImpl;
import org.apache.reef.runtime.common.driver.context.EvaluatorContext;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorMessageDispatcher;
import org.apache.reef.util.Optional;

@ThreadSafe
@DriverSide
@Private
public final class ContextRepresenters {
    private static final Logger LOG = Logger.getLogger(ContextRepresenters.class.getName());
    private final EvaluatorMessageDispatcher messageDispatcher;
    private final ContextFactory contextFactory;
    @GuardedBy(value="this")
    private final List<EvaluatorContext> contextStack = new ArrayList<EvaluatorContext>();
    @GuardedBy(value="this")
    private final Set<String> contextIds = new HashSet<String>();

    @Inject
    private ContextRepresenters(EvaluatorMessageDispatcher messageDispatcher, ContextFactory contextFactory) {
        this.messageDispatcher = messageDispatcher;
        this.contextFactory = contextFactory;
    }

    public synchronized EvaluatorContext getContext(String contextId) {
        for (EvaluatorContext context : this.contextStack) {
            if (!context.getId().equals(contextId)) continue;
            return context;
        }
        throw new RuntimeException("Unknown evaluator context " + contextId);
    }

    public synchronized List<FailedContext> getFailedContextsForEvaluatorFailure() {
        ArrayList<FailedContext> failedContextList = new ArrayList<FailedContext>();
        ArrayList<EvaluatorContext> activeContexts = new ArrayList<EvaluatorContext>(this.contextStack);
        Collections.reverse(activeContexts);
        for (EvaluatorContext context : activeContexts) {
            failedContextList.add(context.getFailedContextForEvaluatorFailure());
        }
        return failedContextList;
    }

    public synchronized void onContextStatusMessages(Iterable<ReefServiceProtos.ContextStatusProto> contextStatusProtos, boolean notifyClientOnNewActiveContext) {
        for (ReefServiceProtos.ContextStatusProto contextStatusProto : contextStatusProtos) {
            this.onContextStatusMessage(contextStatusProto, notifyClientOnNewActiveContext);
        }
    }

    private synchronized void onContextStatusMessage(ReefServiceProtos.ContextStatusProto contextStatusProto, boolean notifyClientOnNewActiveContext) {
        LOG.log(Level.FINER, "Processing context status message for context {0}", contextStatusProto.getContextId());
        switch (contextStatusProto.getContextState()) {
            case READY: {
                this.onContextReady(contextStatusProto, notifyClientOnNewActiveContext);
                break;
            }
            case FAIL: {
                this.onContextFailed(contextStatusProto);
                break;
            }
            case DONE: {
                this.onContextDone(contextStatusProto);
                break;
            }
            default: {
                this.onUnknownContextStatus(contextStatusProto);
            }
        }
        LOG.log(Level.FINER, "Done processing context status message for context {0}", contextStatusProto.getContextId());
    }

    private synchronized void onUnknownContextStatus(ReefServiceProtos.ContextStatusProto contextStatusProto) {
        LOG.log(Level.WARNING, "Received unexpected context status: {0}", contextStatusProto);
        throw new RuntimeException("Received unexpected context status: " + (Object)((Object)contextStatusProto.getContextState()));
    }

    private synchronized void onContextFailed(ReefServiceProtos.ContextStatusProto contextStatusProto) {
        assert (ReefServiceProtos.ContextStatusProto.State.FAIL == contextStatusProto.getContextState());
        String contextID = contextStatusProto.getContextId();
        LOG.log(Level.FINE, "Context {0} failed", contextID);
        if (this.isUnknownContextId(contextID)) {
            this.onNewContext(contextStatusProto, false);
        }
        EvaluatorContext context = this.getContext(contextID);
        this.removeContext(context);
        this.messageDispatcher.onContextFailed(context.getFailedContext(contextStatusProto));
    }

    private synchronized void onContextDone(ReefServiceProtos.ContextStatusProto contextStatusProto) {
        assert (ReefServiceProtos.ContextStatusProto.State.DONE == contextStatusProto.getContextState());
        String contextID = contextStatusProto.getContextId();
        if (this.isUnknownContextId(contextID)) {
            throw new RuntimeException("Received DONE for context " + contextID + " which is unknown.");
        }
        LOG.log(Level.FINE, "Context {0} is DONE.", contextID);
        EvaluatorContext context = this.getContext(contextID);
        this.removeContext(context);
        if (context.isRootContext()) {
            LOG.log(Level.FINE, "Root context {0} closed. Evaluator closed will trigger final shutdown.", contextID);
        } else {
            EvaluatorContext parentContext = this.getContext((String)context.getParentId().get());
            this.messageDispatcher.onContextClose(context.getClosedContext(parentContext));
        }
    }

    private synchronized void onContextReady(ReefServiceProtos.ContextStatusProto contextStatusProto, boolean notifyClientOnNewActiveContext) {
        assert (ReefServiceProtos.ContextStatusProto.State.READY == contextStatusProto.getContextState());
        String contextID = contextStatusProto.getContextId();
        if (this.isUnknownContextId(contextID)) {
            this.onNewContext(contextStatusProto, notifyClientOnNewActiveContext);
        }
        for (ReefServiceProtos.ContextStatusProto.ContextMessageProto contextMessageProto : contextStatusProto.getContextMessageList()) {
            byte[] theMessage = contextMessageProto.getMessage().toByteArray();
            String sourceID = contextMessageProto.getSourceId();
            this.messageDispatcher.onContextMessage(new ContextMessageImpl(theMessage, contextID, sourceID));
        }
    }

    private synchronized void onNewContext(ReefServiceProtos.ContextStatusProto contextStatusProto, boolean notifyClientOnNewActiveContext) {
        String contextID = contextStatusProto.getContextId();
        LOG.log(Level.FINE, "Adding new context {0}.", contextID);
        Optional parentID = contextStatusProto.hasParentId() ? Optional.of((Object)contextStatusProto.getParentId()) : Optional.empty();
        EvaluatorContext context = this.contextFactory.newContext(contextID, (Optional<String>)parentID);
        this.addContext(context);
        if (contextStatusProto.getRecovery()) {
            this.messageDispatcher.OnDriverRestartContextActive(context);
        } else if (notifyClientOnNewActiveContext) {
            this.messageDispatcher.onContextActive(context);
        }
    }

    private synchronized void addContext(EvaluatorContext context) {
        this.contextStack.add(context);
        this.contextIds.add(context.getId());
    }

    private synchronized void removeContext(EvaluatorContext context) {
        this.contextStack.remove(context);
        this.contextIds.remove(context.getId());
    }

    private synchronized boolean isUnknownContextId(String contextId) {
        return !this.contextIds.contains(contextId);
    }
}

