/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.context;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.runtime.common.driver.context.ContextControlHandler;
import org.apache.reef.runtime.common.driver.context.ContextRepresenters;
import org.apache.reef.runtime.common.driver.context.EvaluatorContext;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorMessageDispatcher;
import org.apache.reef.runtime.common.utils.ExceptionCodec;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.Optional;

@ThreadSafe
final class ContextFactory {
    private final String evaluatorId;
    private final EvaluatorDescriptor evaluatorDescriptor;
    private final ConfigurationSerializer configurationSerializer;
    private final ExceptionCodec exceptionCodec;
    private final EvaluatorMessageDispatcher messageDispatcher;
    private final ContextControlHandler contextControlHandler;
    private final InjectionFuture<ContextRepresenters> contextRepresenters;
    @GuardedBy(value="this.priorIds")
    private final Set<String> priorIds = new HashSet<String>();

    @Inject
    ContextFactory(@Parameter(value=EvaluatorManager.EvaluatorIdentifier.class) String evaluatorId, @Parameter(value=EvaluatorManager.EvaluatorDescriptorName.class) EvaluatorDescriptor evaluatorDescriptor, ConfigurationSerializer configurationSerializer, ExceptionCodec exceptionCodec, EvaluatorMessageDispatcher messageDispatcher, ContextControlHandler contextControlHandler, InjectionFuture<ContextRepresenters> contextRepresenters) {
        this.evaluatorId = evaluatorId;
        this.evaluatorDescriptor = evaluatorDescriptor;
        this.configurationSerializer = configurationSerializer;
        this.exceptionCodec = exceptionCodec;
        this.messageDispatcher = messageDispatcher;
        this.contextControlHandler = contextControlHandler;
        this.contextRepresenters = contextRepresenters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EvaluatorContext newContext(String contextId, Optional<String> parentID) {
        Set<String> set = this.priorIds;
        synchronized (set) {
            if (this.priorIds.contains(contextId)) {
                throw new IllegalStateException("Creating second EvaluatorContext instance for id " + contextId);
            }
            this.priorIds.add(contextId);
        }
        return new EvaluatorContext(contextId, this.evaluatorId, this.evaluatorDescriptor, parentID, this.configurationSerializer, this.contextControlHandler, this.messageDispatcher, this.exceptionCodec, (ContextRepresenters)this.contextRepresenters.get());
    }
}

