/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.context;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorControlHandler;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.tang.annotations.Parameter;

@DriverSide
@Private
public class ContextControlHandler {
    private static final Logger LOG = Logger.getLogger(ContextControlHandler.class.getName());
    private final EvaluatorControlHandler evaluatorControlHandler;
    private final String evaluatorId;

    @Inject
    ContextControlHandler(EvaluatorControlHandler evaluatorControlHandler, @Parameter(value=EvaluatorManager.EvaluatorIdentifier.class) String evaluatorId) {
        this.evaluatorControlHandler = evaluatorControlHandler;
        this.evaluatorId = evaluatorId;
        LOG.log(Level.FINE, "Instantiated 'ContextControlHandler'");
    }

    public synchronized void send(EvaluatorRuntimeProtocol.ContextControlProto contextControlProto) {
        EvaluatorRuntimeProtocol.EvaluatorControlProto evaluatorControlProto = EvaluatorRuntimeProtocol.EvaluatorControlProto.newBuilder().setTimestamp(System.currentTimeMillis()).setIdentifier(this.evaluatorId).setContextControl(contextControlProto).build();
        this.evaluatorControlHandler.send(evaluatorControlProto);
    }
}

