/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.context;

import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.ClosedContext;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.util.Optional;

@DriverSide
@Private
public final class ClosedContextImpl
implements ClosedContext {
    private final ActiveContext parentContext;
    private final String contextID;
    private final String evaluatorId;
    private final EvaluatorDescriptor evaluatorDescriptor;

    public ClosedContextImpl(ActiveContext parentContext, String contextID, String evaluatorId, EvaluatorDescriptor evaluatorDescriptor) {
        this.parentContext = parentContext;
        this.contextID = contextID;
        this.evaluatorId = evaluatorId;
        this.evaluatorDescriptor = evaluatorDescriptor;
    }

    @Override
    public ActiveContext getParentContext() {
        return this.parentContext;
    }

    @Override
    public String getId() {
        return this.contextID;
    }

    @Override
    public String getEvaluatorId() {
        return this.evaluatorId;
    }

    @Override
    public Optional<String> getParentId() {
        return Optional.of((Object)this.parentContext.getId());
    }

    @Override
    public EvaluatorDescriptor getEvaluatorDescriptor() {
        return this.evaluatorDescriptor;
    }

    public String toString() {
        return "ClosedContext{contextID='" + this.contextID + '\'' + '}';
    }
}

