/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.client;

import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.parameters.ClientCloseHandlers;
import org.apache.reef.driver.parameters.ClientCloseWithMessageHandlers;
import org.apache.reef.driver.parameters.ClientMessageHandlers;
import org.apache.reef.proto.ClientRuntimeProtocol;
import org.apache.reef.runtime.common.driver.DriverStatusManager;
import org.apache.reef.runtime.common.driver.api.AbstractDriverRuntimeConfiguration;
import org.apache.reef.runtime.common.utils.BroadCastEventHandler;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.wake.EventHandler;

@Private
@DriverSide
public final class ClientManager
implements EventHandler<ClientRuntimeProtocol.JobControlProto> {
    private static final Logger LOG = Logger.getLogger(ClientManager.class.getName());
    private final InjectionFuture<Set<EventHandler<Void>>> clientCloseHandlers;
    private final InjectionFuture<Set<EventHandler<byte[]>>> clientCloseWithMessageHandlers;
    private final InjectionFuture<Set<EventHandler<byte[]>>> clientMessageHandlers;
    private final DriverStatusManager driverStatusManager;
    private volatile EventHandler<Void> clientCloseDispatcher;
    private volatile EventHandler<byte[]> clientCloseWithMessageDispatcher;
    private volatile EventHandler<byte[]> clientMessageDispatcher;

    @Inject
    ClientManager(@Parameter(value=ClientCloseHandlers.class) InjectionFuture<Set<EventHandler<Void>>> clientCloseHandlers, @Parameter(value=ClientCloseWithMessageHandlers.class) InjectionFuture<Set<EventHandler<byte[]>>> clientCloseWithMessageHandlers, @Parameter(value=ClientMessageHandlers.class) InjectionFuture<Set<EventHandler<byte[]>>> clientMessageHandlers, @Parameter(value=AbstractDriverRuntimeConfiguration.ClientRemoteIdentifier.class) String clientRID, RemoteManager remoteManager, DriverStatusManager driverStatusManager) {
        this.driverStatusManager = driverStatusManager;
        this.clientCloseHandlers = clientCloseHandlers;
        this.clientCloseWithMessageHandlers = clientCloseWithMessageHandlers;
        this.clientMessageHandlers = clientMessageHandlers;
        if (!clientRID.equals("NO_ERROR_HANDLER_REMOTE_ID")) {
            remoteManager.registerHandler(clientRID, ClientRuntimeProtocol.JobControlProto.class, this);
        } else {
            LOG.log(Level.FINE, "Not registering a handler for JobControlProto, as there is no client.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onNext(ClientRuntimeProtocol.JobControlProto jobControlProto) {
        if (jobControlProto.hasSignal()) {
            if (jobControlProto.getSignal() == ClientRuntimeProtocol.Signal.SIG_TERMINATE) {
                try {
                    if (jobControlProto.hasMessage()) {
                        this.getClientCloseWithMessageDispatcher().onNext((Object)jobControlProto.getMessage().toByteArray());
                    }
                    this.getClientCloseDispatcher().onNext(null);
                }
                finally {
                    this.driverStatusManager.onComplete();
                }
            } else {
                LOG.log(Level.FINEST, "Unsupported signal: " + (Object)((Object)jobControlProto.getSignal()));
            }
        } else if (jobControlProto.hasMessage()) {
            this.getClientMessageDispatcher().onNext((Object)jobControlProto.getMessage().toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized EventHandler<Void> getClientCloseDispatcher() {
        if (this.clientCloseDispatcher != null) {
            return this.clientCloseDispatcher;
        }
        ClientManager clientManager = this;
        synchronized (clientManager) {
            if (this.clientCloseDispatcher == null) {
                this.clientCloseDispatcher = new BroadCastEventHandler<Void>((Collection)this.clientCloseHandlers.get());
            }
        }
        return this.clientCloseDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventHandler<byte[]> getClientCloseWithMessageDispatcher() {
        if (this.clientCloseWithMessageDispatcher != null) {
            return this.clientCloseWithMessageDispatcher;
        }
        ClientManager clientManager = this;
        synchronized (clientManager) {
            if (this.clientCloseWithMessageDispatcher == null) {
                this.clientCloseWithMessageDispatcher = new BroadCastEventHandler<byte[]>((Collection)this.clientCloseWithMessageHandlers.get());
            }
        }
        return this.clientCloseWithMessageDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventHandler<byte[]> getClientMessageDispatcher() {
        if (this.clientMessageDispatcher != null) {
            return this.clientMessageDispatcher;
        }
        ClientManager clientManager = this;
        synchronized (clientManager) {
            if (this.clientMessageDispatcher == null) {
                this.clientMessageDispatcher = new BroadCastEventHandler<byte[]>((Collection)this.clientMessageHandlers.get());
            }
        }
        return this.clientMessageDispatcher;
    }
}

