/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.client;

import com.google.protobuf.ByteString;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.api.AbstractDriverRuntimeConfiguration;
import org.apache.reef.runtime.common.driver.client.LoggingJobStatusHandler;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.wake.EventHandler;

@DriverSide
public final class ClientConnection {
    private static final Logger LOG = Logger.getLogger(ClientConnection.class.getName());
    private final EventHandler<ReefServiceProtos.JobStatusProto> jobStatusHandler;
    private final String jobIdentifier;

    @Inject
    public ClientConnection(RemoteManager remoteManager, @Parameter(value=AbstractDriverRuntimeConfiguration.ClientRemoteIdentifier.class) String clientRID, @Parameter(value=AbstractDriverRuntimeConfiguration.JobIdentifier.class) String jobIdentifier) {
        this.jobIdentifier = jobIdentifier;
        if (clientRID.equals("NO_ERROR_HANDLER_REMOTE_ID")) {
            LOG.log(Level.FINE, "Instantiated 'ClientConnection' without an actual connection to the client.");
            this.jobStatusHandler = new LoggingJobStatusHandler();
        } else {
            this.jobStatusHandler = remoteManager.getHandler(clientRID, ReefServiceProtos.JobStatusProto.class);
            LOG.log(Level.FINE, "Instantiated 'ClientConnection'");
        }
    }

    public synchronized void send(ReefServiceProtos.JobStatusProto status) {
        LOG.log(Level.FINEST, "Sending:\n" + status);
        this.jobStatusHandler.onNext((Object)status);
    }

    public synchronized void sendMessage(byte[] message) {
        this.send(ReefServiceProtos.JobStatusProto.newBuilder().setIdentifier(this.jobIdentifier).setState(ReefServiceProtos.State.RUNNING).setMessage(ByteString.copyFrom((byte[])message)).build());
    }
}

