/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.catalog;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.catalog.NodeDescriptor;
import org.apache.reef.driver.catalog.RackDescriptor;
import org.apache.reef.driver.catalog.ResourceCatalog;
import org.apache.reef.runtime.common.driver.catalog.NodeDescriptorImpl;
import org.apache.reef.runtime.common.driver.catalog.RackDescriptorImpl;
import org.apache.reef.runtime.common.driver.resourcemanager.NodeDescriptorEvent;

@Private
public final class ResourceCatalogImpl
implements ResourceCatalog {
    public static final String DEFAULT_RACK = "/default-rack";
    private static final Logger LOG = Logger.getLogger(ResourceCatalog.class.getName());
    private final Map<String, RackDescriptorImpl> racks = new HashMap<String, RackDescriptorImpl>();
    private final Map<String, NodeDescriptorImpl> nodes = new HashMap<String, NodeDescriptorImpl>();

    @Inject
    ResourceCatalogImpl() {
        LOG.log(Level.FINE, "Instantiated 'ResourceCatalogImpl'");
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("=== Resource Catalog ===");
        for (RackDescriptor rackDescriptor : this.racks.values()) {
            sb.append("\n" + rackDescriptor);
        }
        return sb.toString();
    }

    @Override
    public synchronized Collection<NodeDescriptor> getNodes() {
        return Collections.unmodifiableCollection(new ArrayList<NodeDescriptorImpl>(this.nodes.values()));
    }

    @Override
    public synchronized Collection<RackDescriptor> getRacks() {
        return Collections.unmodifiableCollection(new ArrayList<RackDescriptorImpl>(this.racks.values()));
    }

    @Override
    public final synchronized NodeDescriptor getNode(String id) {
        return this.nodes.get(id);
    }

    public final synchronized void handle(NodeDescriptorEvent node) {
        RackDescriptorImpl rack;
        String rack_name = (String)node.getRackName().orElse((Object)DEFAULT_RACK);
        LOG.log(Level.FINEST, "Catalog new node: id[{0}], rack[{1}], host[{2}], port[{3}], memory[{4}]", new Object[]{node.getIdentifier(), rack_name, node.getHostName(), node.getPort(), node.getMemorySize()});
        if (!this.racks.containsKey(rack_name)) {
            rack = new RackDescriptorImpl(rack_name);
            this.racks.put(rack_name, rack);
        }
        rack = this.racks.get(rack_name);
        InetSocketAddress address = new InetSocketAddress(node.getHostName(), node.getPort());
        NodeDescriptorImpl nodeDescriptor = new NodeDescriptorImpl(node.getIdentifier(), address, rack, node.getMemorySize());
        this.nodes.put(nodeDescriptor.getId(), nodeDescriptor);
    }
}

