/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.reef.driver.catalog.NodeDescriptor;
import org.apache.reef.driver.catalog.RackDescriptor;
import org.apache.reef.runtime.common.driver.catalog.NodeDescriptorImpl;

public final class RackDescriptorImpl
implements RackDescriptor {
    private final String name;
    private final List<NodeDescriptorImpl> nodes;

    RackDescriptorImpl(String name) {
        this.name = name;
        this.nodes = new ArrayList<NodeDescriptorImpl>();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rack " + this.name);
        for (NodeDescriptorImpl node : this.nodes) {
            sb.append("\n\t" + node);
        }
        return sb.toString();
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof RackDescriptorImpl) {
            return obj.toString().equals(this.name);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<NodeDescriptor> getNodes() {
        return Collections.unmodifiableList(new ArrayList<NodeDescriptorImpl>(this.nodes));
    }

    void addNodeDescriptor(NodeDescriptorImpl node) {
        this.nodes.add(node);
    }
}

