/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.catalog;

import java.net.InetSocketAddress;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.catalog.NodeDescriptor;
import org.apache.reef.driver.catalog.RackDescriptor;
import org.apache.reef.runtime.common.driver.catalog.RackDescriptorImpl;

@Private
public class NodeDescriptorImpl
implements NodeDescriptor {
    private final RackDescriptorImpl rack;
    private final String id;
    private final InetSocketAddress address;
    private final int ram;

    NodeDescriptorImpl(String id, InetSocketAddress address, RackDescriptorImpl rack, int ram) {
        this.id = id;
        this.address = address;
        this.rack = rack;
        this.ram = ram;
        this.rack.addNodeDescriptor(this);
    }

    public String toString() {
        return "Node [" + this.address + "]: RACK " + this.rack.getName() + ", RAM " + this.ram;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.address;
    }

    @Override
    public RackDescriptor getRackDescriptor() {
        return this.rack;
    }

    @Override
    public String getName() {
        return this.address.getHostName();
    }
}

