/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.reef.runtime.common.driver.api.ResourceRequestEvent;
import org.apache.reef.util.BuilderUtils;
import org.apache.reef.util.Optional;

public final class ResourceRequestEventImpl
implements ResourceRequestEvent {
    private final int resourceCount;
    private final List<String> nodeNameList;
    private final List<String> rackNameList;
    private final Optional<Integer> memorySize;
    private final Optional<Integer> priority;
    private final Optional<Integer> virtualCores;
    private final Optional<Boolean> relaxLocality;

    private ResourceRequestEventImpl(Builder builder) {
        this.resourceCount = BuilderUtils.notNull(builder.resourceCount);
        this.nodeNameList = BuilderUtils.notNull(builder.nodeNameList);
        this.rackNameList = BuilderUtils.notNull(builder.rackNameList);
        this.memorySize = Optional.ofNullable((Object)builder.memorySize);
        this.priority = Optional.ofNullable((Object)builder.priority);
        this.virtualCores = Optional.ofNullable((Object)builder.virtualCores);
        this.relaxLocality = Optional.ofNullable((Object)builder.relaxLocality);
    }

    @Override
    public int getResourceCount() {
        return this.resourceCount;
    }

    @Override
    public List<String> getNodeNameList() {
        return this.nodeNameList;
    }

    @Override
    public List<String> getRackNameList() {
        return this.rackNameList;
    }

    @Override
    public Optional<Integer> getMemorySize() {
        return this.memorySize;
    }

    @Override
    public Optional<Integer> getPriority() {
        return this.priority;
    }

    @Override
    public Optional<Integer> getVirtualCores() {
        return this.virtualCores;
    }

    @Override
    public Optional<Boolean> getRelaxLocality() {
        return this.relaxLocality;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.reef.util.Builder<ResourceRequestEvent> {
        private Integer resourceCount;
        private List<String> nodeNameList = new ArrayList<String>();
        private List<String> rackNameList = new ArrayList<String>();
        private Integer memorySize;
        private Integer priority;
        private Integer virtualCores;
        private Boolean relaxLocality;

        public Builder mergeFrom(ResourceRequestEvent resourceRequestEvent) {
            this.resourceCount = resourceRequestEvent.getResourceCount();
            this.nodeNameList = resourceRequestEvent.getNodeNameList();
            this.rackNameList = resourceRequestEvent.getRackNameList();
            this.memorySize = (Integer)resourceRequestEvent.getMemorySize().orElse(null);
            this.priority = (Integer)resourceRequestEvent.getPriority().orElse(null);
            this.virtualCores = (Integer)resourceRequestEvent.getVirtualCores().orElse(null);
            this.relaxLocality = (Boolean)resourceRequestEvent.getRelaxLocality().orElse(null);
            return this;
        }

        public Builder setResourceCount(int resourceCount) {
            this.resourceCount = resourceCount;
            return this;
        }

        public Builder addNodeName(String nodeName) {
            this.nodeNameList.add(nodeName);
            return this;
        }

        public Builder addRackName(String rackName) {
            this.rackNameList.add(rackName);
            return this;
        }

        public Builder setMemorySize(int memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setVirtualCores(int virtualCores) {
            this.virtualCores = virtualCores;
            return this;
        }

        public Builder setRelaxLocality(boolean relaxLocality) {
            this.relaxLocality = relaxLocality;
            return this;
        }

        @Override
        public ResourceRequestEvent build() {
            return new ResourceRequestEventImpl(this);
        }
    }
}

