/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.api;

import java.util.HashSet;
import java.util.Set;
import org.apache.reef.runtime.common.driver.api.ResourceLaunchEvent;
import org.apache.reef.runtime.common.files.FileResource;
import org.apache.reef.runtime.common.launch.ProcessType;
import org.apache.reef.tang.Configuration;
import org.apache.reef.util.BuilderUtils;

public final class ResourceLaunchEventImpl
implements ResourceLaunchEvent {
    private final String identifier;
    private final String remoteId;
    private final Configuration evaluatorConf;
    private final ProcessType type;
    private final Set<FileResource> fileSet;

    private ResourceLaunchEventImpl(Builder builder) {
        this.identifier = BuilderUtils.notNull(builder.identifier);
        this.remoteId = BuilderUtils.notNull(builder.remoteId);
        this.evaluatorConf = BuilderUtils.notNull(builder.evaluatorConf);
        this.type = BuilderUtils.notNull(builder.type);
        this.fileSet = BuilderUtils.notNull(builder.fileSet);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getRemoteId() {
        return this.remoteId;
    }

    @Override
    public Configuration getEvaluatorConf() {
        return this.evaluatorConf;
    }

    @Override
    public ProcessType getType() {
        return this.type;
    }

    @Override
    public Set<FileResource> getFileSet() {
        return this.fileSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.reef.util.Builder<ResourceLaunchEvent> {
        private String identifier;
        private String remoteId;
        private Configuration evaluatorConf;
        private ProcessType type;
        private Set<FileResource> fileSet = new HashSet<FileResource>();

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setRemoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder setEvaluatorConf(Configuration evaluatorConf) {
            this.evaluatorConf = evaluatorConf;
            return this;
        }

        public Builder setType(ProcessType type) {
            this.type = type;
            return this;
        }

        public Builder addFile(FileResource file) {
            this.fileSet.add(file);
            return this;
        }

        @Override
        public ResourceLaunchEvent build() {
            return new ResourceLaunchEventImpl(this);
        }
    }
}

