/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.catalog.NodeDescriptor;
import org.apache.reef.driver.catalog.RackDescriptor;
import org.apache.reef.driver.catalog.ResourceCatalog;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.runtime.common.driver.api.ResourceRequestEventImpl;
import org.apache.reef.runtime.common.driver.api.ResourceRequestHandler;
import org.apache.reef.util.logging.LoggingScope;
import org.apache.reef.util.logging.LoggingScopeFactory;

public final class EvaluatorRequestorImpl
implements EvaluatorRequestor {
    private static final Logger LOG = Logger.getLogger(EvaluatorRequestorImpl.class.getName());
    private final ResourceCatalog resourceCatalog;
    private final ResourceRequestHandler resourceRequestHandler;
    private final LoggingScopeFactory loggingScopeFactory;

    @Inject
    public EvaluatorRequestorImpl(ResourceCatalog resourceCatalog, ResourceRequestHandler resourceRequestHandler, LoggingScopeFactory loggingScopeFactory) {
        this.resourceCatalog = resourceCatalog;
        this.resourceRequestHandler = resourceRequestHandler;
        this.loggingScopeFactory = loggingScopeFactory;
    }

    @Override
    public synchronized void submit(EvaluatorRequest req) {
        LOG.log(Level.FINEST, "Got an EvaluatorRequest: number: {0}, memory = {1}, cores = {2}.", new Object[]{req.getNumber(), req.getMegaBytes(), req.getNumberOfCores()});
        if (req.getMegaBytes() <= 0) {
            throw new IllegalArgumentException("Given an unsupported memory size: " + req.getMegaBytes());
        }
        if (req.getNumberOfCores() <= 0) {
            throw new IllegalArgumentException("Given an unsupported core number: " + req.getNumberOfCores());
        }
        if (req.getNumber() <= 0) {
            throw new IllegalArgumentException("Given an unsupported number of evaluators: " + req.getNumber());
        }
        try (LoggingScope ls = this.loggingScopeFactory.evaluatorSubmit(req.getNumber());){
            ResourceRequestEventImpl.Builder request = ResourceRequestEventImpl.newBuilder().setResourceCount(req.getNumber()).setVirtualCores(req.getNumberOfCores()).setMemorySize(req.getMegaBytes());
            ResourceCatalog.Descriptor descriptor = req.getDescriptor();
            if (descriptor != null) {
                if (descriptor instanceof RackDescriptor) {
                    request.addRackName(descriptor.getName());
                } else if (descriptor instanceof NodeDescriptor) {
                    request.addNodeName(descriptor.getName());
                } else {
                    throw new IllegalArgumentException("Unable to operate on descriptors of type " + descriptor.getClass().getName());
                }
            }
            this.resourceRequestHandler.onNext(request.build());
        }
    }
}

