/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver;

import com.google.protobuf.ByteString;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.DriverStatus;
import org.apache.reef.runtime.common.driver.api.AbstractDriverRuntimeConfiguration;
import org.apache.reef.runtime.common.driver.client.ClientConnection;
import org.apache.reef.runtime.common.utils.ExceptionCodec;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.time.Clock;

public final class DriverStatusManager {
    private static final Logger LOG = Logger.getLogger(DriverStatusManager.class.getName());
    private final Clock clock;
    private final ClientConnection clientConnection;
    private final String jobIdentifier;
    private final ExceptionCodec exceptionCodec;
    private DriverStatus driverStatus = DriverStatus.PRE_INIT;
    private Optional<Throwable> shutdownCause = Optional.empty();
    private boolean driverTerminationHasBeenCommunicatedToClient = false;
    private boolean restartCompleted = false;
    private int numPreviousContainers = -1;
    private int numRecoveredContainers = 0;

    @Inject
    DriverStatusManager(Clock clock, ClientConnection clientConnection, @Parameter(value=AbstractDriverRuntimeConfiguration.JobIdentifier.class) String jobIdentifier, ExceptionCodec exceptionCodec) {
        LOG.entering(DriverStatusManager.class.getCanonicalName(), "<init>");
        this.clock = clock;
        this.clientConnection = clientConnection;
        this.jobIdentifier = jobIdentifier;
        this.exceptionCodec = exceptionCodec;
        LOG.log(Level.FINE, "Instantiated 'DriverStatusManager'");
        LOG.exiting(DriverStatusManager.class.getCanonicalName(), "<init>");
    }

    private static boolean isLegalTransition(DriverStatus from, DriverStatus to) {
        switch (from) {
            case PRE_INIT: {
                switch (to) {
                    case INIT: {
                        return true;
                    }
                }
                return false;
            }
            case INIT: {
                switch (to) {
                    case RUNNING: {
                        return true;
                    }
                }
                return false;
            }
            case RUNNING: {
                switch (to) {
                    case SHUTTING_DOWN: 
                    case FAILING: {
                        return true;
                    }
                }
                return false;
            }
            case SHUTTING_DOWN: 
            case FAILING: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown input state: " + (Object)((Object)from));
    }

    public synchronized void onInit() {
        LOG.entering(DriverStatusManager.class.getCanonicalName(), "onInit");
        this.clientConnection.send(this.getInitMessage());
        this.setStatus(DriverStatus.INIT);
        LOG.exiting(DriverStatusManager.class.getCanonicalName(), "onInit");
    }

    public synchronized void onRunning() {
        LOG.entering(DriverStatusManager.class.getCanonicalName(), "onRunning");
        if (this.driverStatus.equals((Object)DriverStatus.PRE_INIT)) {
            this.onInit();
        }
        this.clientConnection.send(this.getRunningMessage());
        this.setStatus(DriverStatus.RUNNING);
        LOG.exiting(DriverStatusManager.class.getCanonicalName(), "onRunning");
    }

    public synchronized void onError(Throwable exception) {
        LOG.entering(DriverStatusManager.class.getCanonicalName(), "onError", new Object[]{exception});
        if (this.isShuttingDownOrFailing()) {
            LOG.log(Level.WARNING, "Received an exception while already in shutdown.", exception);
        } else {
            LOG.log(Level.WARNING, "Shutting down the Driver with an exception: ", exception);
            this.shutdownCause = Optional.of((Object)exception);
            this.clock.stop();
            this.setStatus(DriverStatus.FAILING);
        }
        LOG.exiting(DriverStatusManager.class.getCanonicalName(), "onError", new Object[]{exception});
    }

    public synchronized void onComplete() {
        LOG.entering(DriverStatusManager.class.getCanonicalName(), "onComplete");
        if (this.isShuttingDownOrFailing()) {
            LOG.log(Level.WARNING, "Ignoring second call to onComplete()");
        } else {
            LOG.log(Level.INFO, "Clean shutdown of the Driver.");
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Callstack: ", new Exception());
            }
            this.clock.close();
            this.setStatus(DriverStatus.SHUTTING_DOWN);
        }
        LOG.exiting(DriverStatusManager.class.getCanonicalName(), "onComplete");
    }

    public synchronized void sendJobEndingMessageToClient(Optional<Throwable> exception) {
        if (this.isNotShuttingDownOrFailing()) {
            LOG.log(Level.SEVERE, "Sending message in a state different that SHUTTING_DOWN or FAILING. This is likely a illegal call to clock.close() at play. Current state: " + (Object)((Object)this.driverStatus));
        }
        if (this.driverTerminationHasBeenCommunicatedToClient) {
            LOG.log(Level.SEVERE, ".sendJobEndingMessageToClient() called twice. Ignoring the second call");
        } else {
            if (this.shutdownCause.isPresent()) {
                LOG.log(Level.WARNING, "Sending message about an unclean driver shutdown.", (Throwable)this.shutdownCause.get());
            }
            if (exception.isPresent()) {
                LOG.log(Level.WARNING, "There was an exception during clock.close().", (Throwable)exception.get());
            }
            if (this.shutdownCause.isPresent() && exception.isPresent()) {
                LOG.log(Level.WARNING, "The driver is shutdown because of an exception (see above) and there was an exception during clock.close(). Only the first exception will be sent to the client");
            }
            if (this.shutdownCause.isPresent()) {
                this.clientConnection.send(this.getJobEndingMessage(this.shutdownCause));
            } else {
                this.clientConnection.send(this.getJobEndingMessage(exception));
            }
            this.driverTerminationHasBeenCommunicatedToClient = true;
        }
    }

    public synchronized void setRestartCompleted() {
        if (!this.isDriverRestart()) {
            throw new IllegalStateException("setRestartCompleted() called in a Driver that is not, in fact, restarted.");
        }
        if (this.restartCompleted) {
            LOG.log(Level.WARNING, "Calling setRestartCompleted more than once.");
        } else {
            this.restartCompleted = true;
        }
    }

    public synchronized int getNumPreviousContainers() {
        return this.numPreviousContainers;
    }

    public synchronized void setNumPreviousContainers(int num) {
        if (this.numPreviousContainers >= 0) {
            throw new IllegalStateException("Attempting to set the number of expected containers left from a previous container more than once.");
        }
        this.numPreviousContainers = num;
    }

    public synchronized int getNumRecoveredContainers() {
        return this.numRecoveredContainers;
    }

    public synchronized void oneContainerRecovered() {
        ++this.numRecoveredContainers;
        if (this.numRecoveredContainers > this.numPreviousContainers) {
            throw new IllegalStateException("Reconnected to" + this.numRecoveredContainers + "Evaluators while only expecting " + this.numPreviousContainers);
        }
    }

    private synchronized boolean isDriverRestart() {
        return this.getNumPreviousContainers() > 0;
    }

    public synchronized boolean isShuttingDownOrFailing() {
        return DriverStatus.SHUTTING_DOWN.equals((Object)this.driverStatus) || DriverStatus.FAILING.equals((Object)this.driverStatus);
    }

    private synchronized boolean isNotShuttingDownOrFailing() {
        return !this.isShuttingDownOrFailing();
    }

    private synchronized void setStatus(DriverStatus newStatus) {
        if (DriverStatusManager.isLegalTransition(this.driverStatus, newStatus)) {
            this.driverStatus = newStatus;
        } else {
            LOG.log(Level.WARNING, "Illegal state transiton: '" + (Object)((Object)this.driverStatus) + "'->'" + (Object)((Object)newStatus) + "'");
        }
    }

    private synchronized ReefServiceProtos.JobStatusProto getJobEndingMessage(Optional<Throwable> exception) {
        ReefServiceProtos.JobStatusProto message = exception.isPresent() ? ReefServiceProtos.JobStatusProto.newBuilder().setIdentifier(this.jobIdentifier).setState(ReefServiceProtos.State.FAILED).setException(ByteString.copyFrom((byte[])this.exceptionCodec.toBytes((Throwable)exception.get()))).build() : ReefServiceProtos.JobStatusProto.newBuilder().setIdentifier(this.jobIdentifier).setState(ReefServiceProtos.State.DONE).build();
        return message;
    }

    private synchronized ReefServiceProtos.JobStatusProto getInitMessage() {
        return ReefServiceProtos.JobStatusProto.newBuilder().setIdentifier(this.jobIdentifier).setState(ReefServiceProtos.State.INIT).build();
    }

    private synchronized ReefServiceProtos.JobStatusProto getRunningMessage() {
        return ReefServiceProtos.JobStatusProto.newBuilder().setIdentifier(this.jobIdentifier).setState(ReefServiceProtos.State.RUNNING).build();
    }
}

