/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.parameters.DriverRestartHandler;
import org.apache.reef.runtime.common.driver.DriverStatusManager;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

public final class DriverStartHandler
implements EventHandler<StartTime> {
    private static final Logger LOG = Logger.getLogger(DriverStartHandler.class.getName());
    private final Set<EventHandler<StartTime>> startHandlers;
    private final Optional<EventHandler<StartTime>> restartHandler;
    private final DriverStatusManager driverStatusManager;

    @Inject
    DriverStartHandler(@Parameter(value=org.apache.reef.driver.parameters.DriverStartHandler.class) Set<EventHandler<StartTime>> startHandler, @Parameter(value=DriverRestartHandler.class) EventHandler<StartTime> restartHandler, DriverStatusManager driverStatusManager) {
        this.startHandlers = startHandler;
        this.restartHandler = Optional.of(restartHandler);
        this.driverStatusManager = driverStatusManager;
        LOG.log(Level.FINE, "Instantiated `DriverStartHandler with StartHandler [{0}] and RestartHandler [{1}]", new String[]{this.startHandlers.toString(), this.restartHandler.toString()});
    }

    @Inject
    DriverStartHandler(@Parameter(value=org.apache.reef.driver.parameters.DriverStartHandler.class) Set<EventHandler<StartTime>> startHandler, DriverStatusManager driverStatusManager) {
        this.startHandlers = startHandler;
        this.restartHandler = Optional.empty();
        this.driverStatusManager = driverStatusManager;
        LOG.log(Level.FINE, "Instantiated `DriverStartHandler with StartHandler [{0}] and no RestartHandler", this.startHandlers.toString());
    }

    public void onNext(StartTime startTime) {
        if (this.isRestart()) {
            this.onRestart(startTime);
        } else {
            this.onStart(startTime);
        }
    }

    private void onRestart(StartTime startTime) {
        if (!this.restartHandler.isPresent()) {
            throw new RuntimeException("Driver restart happened, but no ON_DRIVER_RESTART handler is bound.");
        }
        ((EventHandler)this.restartHandler.get()).onNext((Object)startTime);
    }

    private void onStart(StartTime startTime) {
        for (EventHandler<StartTime> startHandler : this.startHandlers) {
            startHandler.onNext((Object)startTime);
        }
    }

    private boolean isRestart() {
        return this.driverStatusManager.getNumPreviousContainers() > 0;
    }
}

