/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.common.driver.DriverStatusManager;
import org.apache.reef.runtime.common.driver.evaluator.Evaluators;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.runtime.event.RuntimeStop;

@Private
@DriverSide
final class DriverRuntimeStopHandler
implements EventHandler<RuntimeStop> {
    private static final Logger LOG = Logger.getLogger(DriverRuntimeStopHandler.class.getName());
    private final DriverStatusManager driverStatusManager;
    private final RemoteManager remoteManager;
    private final Evaluators evaluators;

    @Inject
    DriverRuntimeStopHandler(DriverStatusManager driverStatusManager, RemoteManager remoteManager, Evaluators evaluators) {
        this.driverStatusManager = driverStatusManager;
        this.remoteManager = remoteManager;
        this.evaluators = evaluators;
    }

    public synchronized void onNext(RuntimeStop runtimeStop) {
        LOG.log(Level.FINEST, "RuntimeStop: {0}", runtimeStop);
        this.evaluators.close();
        Optional exception = Optional.ofNullable((Object)runtimeStop.getException());
        this.driverStatusManager.sendJobEndingMessageToClient((Optional<Throwable>)exception);
        try {
            this.remoteManager.close();
            LOG.log(Level.INFO, "Driver shutdown complete");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to close the RemoteManager.", e);
        }
    }
}

