/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.DriverSingletons;
import org.apache.reef.runtime.common.driver.DriverStatusManager;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorHeartbeatHandler;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorResourceManagerErrorHandler;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceManagerStatus;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.runtime.event.RuntimeStart;

final class DriverRuntimeStartHandler
implements EventHandler<RuntimeStart> {
    private static final Logger LOG = Logger.getLogger(DriverRuntimeStartHandler.class.getName());
    private final RemoteManager remoteManager;
    private final EvaluatorResourceManagerErrorHandler evaluatorResourceManagerErrorHandler;
    private final EvaluatorHeartbeatHandler evaluatorHeartbeatHandler;
    private final ResourceManagerStatus resourceManagerStatus;
    private final DriverStatusManager driverStatusManager;

    @Inject
    DriverRuntimeStartHandler(DriverSingletons singletons, RemoteManager remoteManager, EvaluatorResourceManagerErrorHandler evaluatorResourceManagerErrorHandler, EvaluatorHeartbeatHandler evaluatorHeartbeatHandler, ResourceManagerStatus resourceManagerStatus, DriverStatusManager driverStatusManager) {
        this.remoteManager = remoteManager;
        this.evaluatorResourceManagerErrorHandler = evaluatorResourceManagerErrorHandler;
        this.evaluatorHeartbeatHandler = evaluatorHeartbeatHandler;
        this.resourceManagerStatus = resourceManagerStatus;
        this.driverStatusManager = driverStatusManager;
    }

    public synchronized void onNext(RuntimeStart runtimeStart) {
        LOG.log(Level.FINEST, "RuntimeStart: {0}", runtimeStart);
        this.remoteManager.registerHandler(EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto.class, this.evaluatorHeartbeatHandler);
        this.remoteManager.registerHandler(ReefServiceProtos.RuntimeErrorProto.class, this.evaluatorResourceManagerErrorHandler);
        this.resourceManagerStatus.setRunning();
        this.driverStatusManager.onRunning();
        LOG.log(Level.FINEST, "DriverRuntimeStartHandler complete.");
    }
}

