/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.client.defaults;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.Provided;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.client.FailedRuntime;
import org.apache.reef.wake.EventHandler;

@Provided
@ClientSide
public final class DefaultRuntimeErrorHandler
implements EventHandler<FailedRuntime> {
    private static final Logger LOG = Logger.getLogger(DefaultRuntimeErrorHandler.class.getName());

    @Inject
    private DefaultRuntimeErrorHandler() {
    }

    public void onNext(FailedRuntime error) {
        if (error.getReason().isPresent()) {
            LOG.log(Level.SEVERE, "Runtime error: " + error, (Throwable)error.getReason().get());
        } else {
            LOG.log(Level.SEVERE, "Runtime error: " + error);
        }
        throw new RuntimeException("REEF runtime error: " + error, error.asError());
    }
}

