/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.client.api;

import java.util.HashSet;
import java.util.Set;
import org.apache.reef.runtime.common.client.api.JobSubmissionEvent;
import org.apache.reef.runtime.common.files.FileResource;
import org.apache.reef.tang.Configuration;
import org.apache.reef.util.BuilderUtils;
import org.apache.reef.util.Optional;

public final class JobSubmissionEventImpl
implements JobSubmissionEvent {
    private final String identifier;
    private final String remoteId;
    private final Configuration configuration;
    private final String userName;
    private final Set<FileResource> globalFileSet;
    private final Set<FileResource> localFileSet;
    private final Optional<Integer> driverMemory;
    private final Optional<Integer> priority;
    private final Optional<String> queue;

    private JobSubmissionEventImpl(Builder builder) {
        this.identifier = BuilderUtils.notNull(builder.identifier);
        this.remoteId = BuilderUtils.notNull(builder.remoteId);
        this.configuration = BuilderUtils.notNull(builder.configuration);
        this.userName = BuilderUtils.notNull(builder.userName);
        this.globalFileSet = BuilderUtils.notNull(builder.globalFileSet);
        this.localFileSet = BuilderUtils.notNull(builder.localFileSet);
        this.driverMemory = Optional.ofNullable((Object)builder.driverMemory);
        this.priority = Optional.ofNullable((Object)builder.priority);
        this.queue = Optional.ofNullable((Object)builder.queue);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getRemoteId() {
        return this.remoteId;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public Set<FileResource> getGlobalFileSet() {
        return this.globalFileSet;
    }

    @Override
    public Set<FileResource> getLocalFileSet() {
        return this.localFileSet;
    }

    @Override
    public Optional<Integer> getDriverMemory() {
        return this.driverMemory;
    }

    @Override
    public Optional<Integer> getPriority() {
        return this.priority;
    }

    @Override
    public Optional<String> getQueue() {
        return this.queue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.reef.util.Builder<JobSubmissionEvent> {
        private String identifier;
        private String remoteId;
        private Configuration configuration;
        private String userName;
        private Set<FileResource> globalFileSet = new HashSet<FileResource>();
        private Set<FileResource> localFileSet = new HashSet<FileResource>();
        private Integer driverMemory;
        private Integer priority;
        private String queue;

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setRemoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder addGlobalFile(FileResource globalFile) {
            this.globalFileSet.add(globalFile);
            return this;
        }

        public Builder addLocalFile(FileResource localFile) {
            this.localFileSet.add(localFile);
            return this;
        }

        public Builder setDriverMemory(Integer driverMemory) {
            this.driverMemory = driverMemory;
            return this;
        }

        public Builder setPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder setQueue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public JobSubmissionEvent build() {
            return new JobSubmissionEventImpl(this);
        }
    }
}

