/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.client.RunningJobs;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.RemoteMessage;

final class RuntimeErrorProtoHandler
implements EventHandler<RemoteMessage<ReefServiceProtos.RuntimeErrorProto>> {
    private static final Logger LOG = Logger.getLogger(RuntimeErrorProtoHandler.class.getName());
    private final InjectionFuture<RunningJobs> runningJobs;

    @Inject
    RuntimeErrorProtoHandler(InjectionFuture<RunningJobs> runningJobs) {
        this.runningJobs = runningJobs;
    }

    public void onNext(RemoteMessage<ReefServiceProtos.RuntimeErrorProto> error) {
        LOG.log(Level.WARNING, "{0} Runtime Error: {1}", new Object[]{error.getIdentifier(), ((ReefServiceProtos.RuntimeErrorProto)error.getMessage()).getMessage()});
        ((RunningJobs)this.runningJobs.get()).onRuntimeErrorMessage(error);
    }
}

