/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.client;

import java.util.Set;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.Provided;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.client.REEF;
import org.apache.reef.client.parameters.DriverConfigurationProviders;
import org.apache.reef.runtime.common.client.ClientWireUp;
import org.apache.reef.runtime.common.client.JobStatusMessageHandler;
import org.apache.reef.runtime.common.client.JobSubmissionHelper;
import org.apache.reef.runtime.common.client.RunningJobs;
import org.apache.reef.runtime.common.client.api.JobSubmissionEvent;
import org.apache.reef.runtime.common.client.api.JobSubmissionHandler;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.ConfigurationProvider;
import org.apache.reef.tang.JavaConfigurationBuilder;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Name;
import org.apache.reef.tang.annotations.NamedParameter;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.util.REEFVersion;
import org.apache.reef.util.logging.LoggingScope;
import org.apache.reef.util.logging.LoggingScopeFactory;

@ClientSide
@Provided
@Private
public final class REEFImplementation
implements REEF {
    private static final Logger LOG = Logger.getLogger(REEFImplementation.class.getName());
    private final JobSubmissionHandler jobSubmissionHandler;
    private final RunningJobs runningJobs;
    private final JobSubmissionHelper jobSubmissionHelper;
    private final ClientWireUp clientWireUp;
    private final LoggingScopeFactory loggingScopeFactory;
    private final Set<ConfigurationProvider> configurationProviders;

    @Inject
    REEFImplementation(JobSubmissionHandler jobSubmissionHandler, RunningJobs runningJobs, JobSubmissionHelper jobSubmissionHelper, JobStatusMessageHandler jobStatusMessageHandler, ClientWireUp clientWireUp, LoggingScopeFactory loggingScopeFactory, REEFVersion reefVersion, @Parameter(value=DriverConfigurationProviders.class) Set<ConfigurationProvider> configurationProviders) {
        this.jobSubmissionHandler = jobSubmissionHandler;
        this.runningJobs = runningJobs;
        this.jobSubmissionHelper = jobSubmissionHelper;
        this.clientWireUp = clientWireUp;
        this.configurationProviders = configurationProviders;
        clientWireUp.performWireUp();
        this.loggingScopeFactory = loggingScopeFactory;
        reefVersion.logVersion();
    }

    @Override
    public final void close() {
        this.runningJobs.closeAllJobs();
        this.clientWireUp.close();
    }

    @Override
    public void submit(Configuration driverConf) {
        try (LoggingScope ls = this.loggingScopeFactory.reefSubmit();){
            JobSubmissionEvent submissionMessage;
            Configuration driverConfiguration = this.createDriverConfiguration(driverConf);
            try {
                submissionMessage = this.clientWireUp.isClientPresent() ? this.jobSubmissionHelper.getJobSubmissionBuilder(driverConf).setRemoteId(this.clientWireUp.getRemoteManagerIdentifier()).build() : this.jobSubmissionHelper.getJobSubmissionBuilder(driverConf).setRemoteId("NO_ERROR_HANDLER_REMOTE_ID").build();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while processing driver configuration.", e);
            }
            this.jobSubmissionHandler.onNext(submissionMessage);
        }
    }

    private Configuration createDriverConfiguration(Configuration driverConfiguration) {
        JavaConfigurationBuilder configurationBuilder = Tang.Factory.getTang().newConfigurationBuilder(new Configuration[]{driverConfiguration});
        for (ConfigurationProvider configurationProvider : this.configurationProviders) {
            configurationBuilder.addConfiguration(configurationProvider.getConfiguration());
        }
        return configurationBuilder.build();
    }

    @NamedParameter(doc="The driver remote identifier.")
    public static final class DriverRemoteIdentifier
    implements Name<String> {
    }
}

