/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.client;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.parameters.DriverIdentifier;
import org.apache.reef.driver.parameters.DriverLocalFiles;
import org.apache.reef.driver.parameters.DriverLocalLibraries;
import org.apache.reef.driver.parameters.DriverMemory;
import org.apache.reef.driver.parameters.JobGlobalFiles;
import org.apache.reef.driver.parameters.JobGlobalLibraries;
import org.apache.reef.runtime.common.client.api.JobSubmissionEventImpl;
import org.apache.reef.runtime.common.files.FileResource;
import org.apache.reef.runtime.common.files.FileResourceImpl;
import org.apache.reef.runtime.common.files.FileType;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.JARFileMaker;

final class JobSubmissionHelper {
    private static final Logger LOG;
    private final ConfigurationSerializer configurationSerializer;

    @Inject
    JobSubmissionHelper(ConfigurationSerializer configurationSerializer) {
        this.configurationSerializer = configurationSerializer;
    }

    final JobSubmissionEventImpl.Builder getJobSubmissionBuilder(Configuration driverConfiguration) throws InjectionException, IOException {
        Injector injector = Tang.Factory.getTang().newInjector(driverConfiguration);
        JobSubmissionEventImpl.Builder jbuilder = JobSubmissionEventImpl.newBuilder().setIdentifier(JobSubmissionHelper.returnOrGenerateDriverId((String)injector.getNamedInstance(DriverIdentifier.class))).setDriverMemory((Integer)injector.getNamedInstance(DriverMemory.class)).setUserName(System.getProperty("user.name")).setConfiguration(driverConfiguration);
        for (String globalFileName : (Set)injector.getNamedInstance(JobGlobalFiles.class)) {
            LOG.log(Level.FINEST, "Adding global file: {0}", globalFileName);
            jbuilder.addGlobalFile(JobSubmissionHelper.getFileResourceProto(globalFileName, FileType.PLAIN));
        }
        for (String globalLibraryName : (Set)injector.getNamedInstance(JobGlobalLibraries.class)) {
            LOG.log(Level.FINEST, "Adding global library: {0}", globalLibraryName);
            jbuilder.addGlobalFile(JobSubmissionHelper.getFileResourceProto(globalLibraryName, FileType.LIB));
        }
        for (String localFileName : (Set)injector.getNamedInstance(DriverLocalFiles.class)) {
            LOG.log(Level.FINEST, "Adding local file: {0}", localFileName);
            jbuilder.addLocalFile(JobSubmissionHelper.getFileResourceProto(localFileName, FileType.PLAIN));
        }
        for (String localLibraryName : (Set)injector.getNamedInstance(DriverLocalLibraries.class)) {
            LOG.log(Level.FINEST, "Adding local library: {0}", localLibraryName);
            jbuilder.addLocalFile(JobSubmissionHelper.getFileResourceProto(localLibraryName, FileType.LIB));
        }
        return jbuilder;
    }

    private static String returnOrGenerateDriverId(String configuredId) {
        String result;
        if (configuredId.equals("##NONE##DEFAULT##NEVERUSE##")) {
            LOG.log(Level.FINE, "No Job Identifier given. Generating a unique one.");
            result = "REEF-" + System.getProperty("user.name", "UNKNOWN_USER") + "-" + System.currentTimeMillis();
        } else {
            result = configuredId;
        }
        return result;
    }

    private static FileResource getFileResourceProto(String fileName, FileType type) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                file = JobSubmissionHelper.toJar(file);
            }
            return FileResourceImpl.newBuilder().setName(file.getName()).setPath(file.getPath()).setType(type).build();
        }
        try {
            URI uri = new URI(fileName);
            String path = uri.getPath();
            String name = path.substring(path.lastIndexOf(47) + 1);
            return FileResourceImpl.newBuilder().setName(name).setPath(uri.toString()).setType(type).build();
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to parse URI.", e);
        }
    }

    private static File toJar(File file) throws IOException {
        File tempFolder = Files.createTempDirectory("reef-tmp-tempFolder", new FileAttribute[0]).toFile();
        File jarFile = File.createTempFile(file.getCanonicalFile().getName(), ".jar", tempFolder);
        LOG.log(Level.FINEST, "Adding contents of folder {0} to {1}", new Object[]{file, jarFile});
        try (JARFileMaker jarMaker = new JARFileMaker(jarFile);){
            jarMaker.addChildren(file);
        }
        return jarFile;
    }

    static {
        System.out.println("\nPowered by\n     ___________  ______  ______  _______\n    /  ______  / /  ___/ /  ___/ /  ____/\n   /     _____/ /  /__  /  /__  /  /___\n  /  /\\  \\     /  ___/ /  ___/ /  ____/\n /  /  \\  \\   /  /__  /  /__  /  /\n/__/    \\__\\ /_____/ /_____/ /__/\n");
        LOG = Logger.getLogger(JobSubmissionHelper.class.getName());
    }
}

