/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.client.RunningJobs;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.RemoteMessage;

@ClientSide
@Private
final class JobStatusMessageHandler
implements EventHandler<RemoteMessage<ReefServiceProtos.JobStatusProto>> {
    private final Logger LOG = Logger.getLogger(JobStatusMessageHandler.class.getName());
    private final RunningJobs runningJobs;

    @Inject
    JobStatusMessageHandler(RunningJobs runningJobs) {
        this.runningJobs = runningJobs;
        this.LOG.log(Level.FINE, "Instantiated 'JobStatusMessageHandler'");
    }

    public void onNext(RemoteMessage<ReefServiceProtos.JobStatusProto> jobStatusProtoRemoteMessage) {
        this.runningJobs.onJobStatusMessage(jobStatusProtoRemoteMessage);
    }
}

