/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.client.JobStatusMessageHandler;
import org.apache.reef.runtime.common.client.RuntimeErrorProtoHandler;
import org.apache.reef.runtime.common.client.parameters.ClientPresent;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.util.Optional;

@ClientSide
@Private
final class ClientWireUp {
    private static final Logger LOG = Logger.getLogger(ClientWireUp.class.getName());
    private final RuntimeErrorProtoHandler runtimeErrorProtoHandler;
    private final JobStatusMessageHandler jobStatusMessageHandler;
    private final Optional<RemoteManager> remoteManager;
    private final boolean isClientPresent;
    private boolean isWired = false;

    @Inject
    ClientWireUp(RemoteManager remoteManager, @Parameter(value=ClientPresent.class) String clientPresent, RuntimeErrorProtoHandler runtimeErrorProtoHandler, JobStatusMessageHandler jobStatusMessageHandler) {
        this.remoteManager = Optional.ofNullable((Object)remoteManager);
        this.runtimeErrorProtoHandler = runtimeErrorProtoHandler;
        this.jobStatusMessageHandler = jobStatusMessageHandler;
        this.isClientPresent = clientPresent.equals("YES");
        LOG.log(Level.FINE, "Instantiated 'ClientWireUp'. Client present: " + this.isClientPresent());
    }

    @Inject
    ClientWireUp(@Parameter(value=ClientPresent.class) String clientPresent, RuntimeErrorProtoHandler runtimeErrorProtoHandler, JobStatusMessageHandler jobStatusMessageHandler) {
        this(null, clientPresent, runtimeErrorProtoHandler, jobStatusMessageHandler);
    }

    synchronized void performWireUp() {
        if (this.isWired) {
            throw new IllegalStateException("performWireUp is only to be called once.");
        }
        if (this.remoteManager.isPresent()) {
            LOG.log(Level.FINEST, "Wiring up communications channels to the Driver.");
            RemoteManager rm = (RemoteManager)this.remoteManager.get();
            rm.registerHandler(ReefServiceProtos.RuntimeErrorProto.class, this.runtimeErrorProtoHandler);
            rm.registerHandler(ReefServiceProtos.JobStatusProto.class, this.jobStatusMessageHandler);
            LOG.log(Level.FINE, "Wired up communications channels to the Driver.");
        }
        this.isWired = true;
    }

    synchronized boolean isClientPresent() {
        return this.isClientPresent;
    }

    synchronized String getRemoteManagerIdentifier() {
        if (!this.isClientPresent() || !this.remoteManager.isPresent()) {
            throw new RuntimeException("No need to setup the remote manager.");
        }
        return ((RemoteManager)this.remoteManager.get()).getMyIdentifier();
    }

    synchronized void close() {
        if (this.remoteManager.isPresent()) {
            try {
                ((RemoteManager)this.remoteManager.get()).close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception while shutting down the RemoteManager.", e);
            }
        }
    }
}

