/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.runtime.common.launch.LaunchClass;
import org.apache.reef.runtime.common.launch.REEFErrorHandler;
import org.apache.reef.runtime.common.launch.REEFMessageCodec;
import org.apache.reef.runtime.common.launch.parameters.ClockConfigurationPath;
import org.apache.reef.runtime.common.launch.parameters.ErrorHandlerRID;
import org.apache.reef.runtime.common.launch.parameters.LaunchID;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.ConfigurationBuilder;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.JavaConfigurationBuilder;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.CommandLine;
import org.apache.reef.util.EnvironmentUtils;
import org.apache.reef.util.ThreadLogger;
import org.apache.reef.util.logging.LoggingSetup;
import org.apache.reef.wake.remote.RemoteConfiguration;

public final class Launcher {
    private static final Logger LOG = Logger.getLogger(Launcher.class.getName());

    private Launcher() {
    }

    private static Configuration processCommandLine(String[] args) throws BindException, IOException, InjectionException {
        JavaConfigurationBuilder commandLineBuilder = Tang.Factory.getTang().newConfigurationBuilder();
        new CommandLine((ConfigurationBuilder)commandLineBuilder).registerShortNameOfClass(ClockConfigurationPath.class).registerShortNameOfClass(ErrorHandlerRID.class).registerShortNameOfClass(LaunchID.class).processCommandLine(args, new Class[0]);
        return commandLineBuilder.bindNamedParameter(RemoteConfiguration.ErrorHandler.class, REEFErrorHandler.class).bindNamedParameter(RemoteConfiguration.ManagerName.class, "REEF_LAUNCHER").bindNamedParameter(RemoteConfiguration.MessageCodec.class, REEFMessageCodec.class).build();
    }

    private static void fail(String msg, Throwable t) {
        LOG.log(Level.SEVERE, msg, t);
        throw new RuntimeException(msg, t);
    }

    public static void main(String[] args) {
        LOG.log(Level.FINE, "Launcher started with user name [{0}]", System.getProperty("user.name"));
        LOG.log(Level.FINE, "Launcher started. Assertions are {0} in this process.", EnvironmentUtils.areAssertionsEnabled() ? "ENABLED" : "DISABLED");
        Injector injector = null;
        try {
            injector = Tang.Factory.getTang().newInjector(Launcher.processCommandLine(args));
        }
        catch (IOException | BindException | InjectionException e) {
            Launcher.fail("Error in parsing the command line", e);
        }
        try (LaunchClass lc = (LaunchClass)injector.getInstance(LaunchClass.class);){
            LOG.log(Level.FINE, "Launcher starting");
            lc.run();
            LOG.log(Level.FINE, "Launcher exiting");
        }
        catch (Throwable throwable) {
            Launcher.fail("Unable to run LaunchClass", throwable);
        }
        LOG.log(Level.INFO, "Exiting Launcher.main()");
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, ThreadLogger.getFormattedThreadList("Threads running after Launcher.close():"));
        }
        System.exit(0);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, ThreadLogger.getFormattedThreadList("Threads running after System.exit():"));
        }
    }

    public static void propagateProperties(Collection<String> vargs, boolean copyNull, String ... propNames) {
        for (String propName : propNames) {
            String propValue = System.getProperty(propName);
            if (propValue == null || propValue.isEmpty()) {
                if (!copyNull) continue;
                vargs.add("-D" + propName);
                continue;
            }
            vargs.add(String.format("-D%s=%s", propName, propValue));
        }
    }

    public static void propagateProperties(Collection<String> vargs, String ... propNames) {
        Launcher.propagateProperties(vargs, false, propNames);
    }

    static {
        LoggingSetup.setupCommonsLogging();
    }
}

