/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.io.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.io.serialization.Codec;

public class SerializableCodec<T extends Serializable>
implements Codec<T> {
    private static final Logger LOG = Logger.getLogger(SerializableCodec.class.getName());

    @Inject
    public SerializableCodec() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] encode(T obj) {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            try (ObjectOutputStream out = new ObjectOutputStream(bout);){
                out.writeObject(obj);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to encode: " + obj, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T decode(byte[] buf) {
        try (ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(buf));){
            Serializable result;
            Serializable serializable = result = (Serializable)oin.readObject();
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException("Unable to decode.", ex);
        }
    }
}

