/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.Provided;
import org.apache.reef.io.TempFileCreator;

@Provided
public final class WorkingDirectoryTempFileCreator
implements TempFileCreator {
    private static final Logger LOG = Logger.getLogger(WorkingDirectoryTempFileCreator.class.getName());
    private final File tempFolderAsFile = new File("./reef/temp");
    private final Path tempFolderAsPath;

    @Inject
    WorkingDirectoryTempFileCreator() throws IOException {
        this.tempFolderAsFile.mkdirs();
        this.tempFolderAsPath = this.tempFolderAsFile.toPath();
        LOG.log(Level.FINE, "Temporary files and folders will be created in [{0}]", this.tempFolderAsFile.getAbsolutePath());
    }

    @Override
    public File createTempFile(String prefix, String suffix) throws IOException {
        File result = File.createTempFile(prefix, suffix, this.tempFolderAsFile);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Created temporary file: {0}", result.getAbsolutePath());
        }
        return result;
    }

    @Override
    public File createTempDirectory(String prefix, FileAttribute<?> fileAttributes) throws IOException {
        File result = Files.createTempDirectory(this.tempFolderAsPath, prefix, fileAttributes).toFile();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Created temporary folder: {0}", result.getAbsolutePath());
        }
        return result;
    }

    @Override
    public File createTempDirectory(String prefix) throws IOException {
        File result = Files.createTempDirectory(this.tempFolderAsPath, prefix, new FileAttribute[0]).toFile();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Created temporary folder: {0}", result.getAbsolutePath());
        }
        return result;
    }
}

