/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.io.TempFileCreator;

public final class SystemTempFileCreator
implements TempFileCreator {
    private static final Logger LOG = Logger.getLogger(SystemTempFileCreator.class.getName());

    @Inject
    public SystemTempFileCreator() {
        LOG.log(Level.FINE, "Temporary files and folders will be created in the system temp folder.");
    }

    @Override
    public File createTempFile(String prefix, String suffix) throws IOException {
        File result = File.createTempFile(prefix, suffix);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Created temporary file: {0}", result.getAbsolutePath());
        }
        return result;
    }

    @Override
    public File createTempDirectory(String prefix, FileAttribute<?> attributes) throws IOException {
        File result = Files.createTempDirectory(prefix, attributes).toFile();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Created temporary folder: {0}", result.getAbsolutePath());
        }
        return result;
    }

    @Override
    public File createTempDirectory(String prefix) throws IOException {
        File result = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Created temporary folder: {0}", result.getAbsolutePath());
        }
        return result;
    }
}

