/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.driver.evaluator;

import org.apache.reef.annotations.Provided;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Public;
import org.apache.reef.driver.catalog.ResourceCatalog;

@Public
@DriverSide
@Provided
public final class EvaluatorRequest {
    private final int megaBytes;
    private final int number;
    private final int cores;
    private final ResourceCatalog.Descriptor descriptor;

    EvaluatorRequest(int number, int megaBytes, int cores, ResourceCatalog.Descriptor descriptor) {
        this.number = number;
        this.megaBytes = megaBytes;
        this.cores = cores;
        this.descriptor = descriptor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(EvaluatorRequest request) {
        return new Builder(request);
    }

    public int getNumber() {
        return this.number;
    }

    public int getNumberOfCores() {
        return this.cores;
    }

    public final ResourceCatalog.Descriptor getDescriptor() {
        return this.descriptor;
    }

    public int getMegaBytes() {
        return this.megaBytes;
    }

    public static class Builder
    implements org.apache.reef.util.Builder<EvaluatorRequest> {
        private int n = 1;
        private ResourceCatalog.Descriptor descriptor = null;
        private int megaBytes = -1;
        private int cores = 1;

        private Builder() {
        }

        private Builder(EvaluatorRequest request) {
            this.setNumber(request.getNumber());
            this.fromDescriptor(request.getDescriptor());
        }

        public Builder setMemory(int megaBytes) {
            this.megaBytes = megaBytes;
            return this;
        }

        public Builder setNumberOfCores(int cores) {
            this.cores = cores;
            return this;
        }

        public Builder setNumber(int n) {
            this.n = n;
            return this;
        }

        @Override
        public EvaluatorRequest build() {
            return new EvaluatorRequest(this.n, this.megaBytes, this.cores, this.descriptor);
        }

        public Builder fromDescriptor(ResourceCatalog.Descriptor rd) {
            this.descriptor = rd;
            return this;
        }
    }
}

