/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.reef.common.Failure;
import org.apache.reef.util.Optional;

public abstract class AbstractFailure
implements Failure {
    protected final String id;
    protected final String message;
    protected final Optional<String> description;
    protected final Optional<Throwable> cause;
    protected final Optional<byte[]> data;

    protected AbstractFailure(String id, String message, Optional<String> description, Optional<Throwable> cause, Optional<byte[]> data) {
        this.id = id;
        this.message = message;
        this.description = description;
        this.cause = cause;
        this.data = data;
    }

    protected static String getStackTrace(Throwable cause) {
        if (cause == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    public Optional<Throwable> getReason() {
        return this.cause;
    }

    @Override
    public Optional<byte[]> getData() {
        return this.data;
    }

    @Override
    public Throwable asError() {
        return this.cause.isPresent() ? (Throwable)this.cause.get() : new RuntimeException(this.toString());
    }

    public String toString() {
        return this.getClass().getName() + " id=" + this.getId() + " failed: " + this.getMessage();
    }
}

