/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.client;

import org.apache.reef.util.Optional;

public final class LauncherStatus {
    public static final LauncherStatus INIT = new LauncherStatus(State.INIT);
    public static final LauncherStatus RUNNING = new LauncherStatus(State.RUNNING);
    public static final LauncherStatus COMPLETED = new LauncherStatus(State.COMPLETED);
    public static final LauncherStatus FORCE_CLOSED = new LauncherStatus(State.FORCE_CLOSED);
    public static final LauncherStatus FAILED = new LauncherStatus(State.FAILED);
    private final State state;
    private final Optional<Throwable> error;

    private LauncherStatus(State state) {
        this(state, null);
    }

    private LauncherStatus(State state, Throwable ex) {
        this.state = state;
        this.error = Optional.ofNullable((Object)ex);
    }

    public static final LauncherStatus FAILED(Throwable ex) {
        return new LauncherStatus(State.FAILED, ex);
    }

    public static final LauncherStatus FAILED(Optional<Throwable> ex) {
        return new LauncherStatus(State.FAILED, (Throwable)ex.orElse(null));
    }

    public Optional<Throwable> getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof LauncherStatus && ((LauncherStatus)other).state == this.state;
    }

    public final boolean isDone() {
        switch (this.state) {
            case FAILED: 
            case COMPLETED: 
            case FORCE_CLOSED: {
                return true;
            }
        }
        return false;
    }

    public final boolean isSuccess() {
        return this.state == State.COMPLETED;
    }

    public final boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public String toString() {
        if (this.error.isPresent()) {
            return (Object)((Object)this.state) + "(" + this.error.get() + ")";
        }
        return this.state.toString();
    }

    private static enum State {
        INIT,
        RUNNING,
        COMPLETED,
        FAILED,
        FORCE_CLOSED;

    }
}

