/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.common.AbstractFailure;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.remote.impl.ObjectSerializableCodec;

public final class FailedRuntime
extends AbstractFailure {
    private static final Logger LOG = Logger.getLogger(AbstractFailure.class.getName());
    private static final ObjectSerializableCodec<Exception> CODEC = new ObjectSerializableCodec();

    public FailedRuntime(ReefServiceProtos.RuntimeErrorProto error) {
        super(error.getIdentifier(), error.getMessage(), (Optional<String>)Optional.empty(), (Optional<Throwable>)Optional.of((Object)FailedRuntime.getThrowable(error)), (Optional<byte[]>)Optional.empty());
    }

    private static Throwable getThrowable(ReefServiceProtos.RuntimeErrorProto error) {
        byte[] data = FailedRuntime.getData(error);
        if (data != null) {
            try {
                return (Throwable)CODEC.decode(data);
            }
            catch (Throwable ex) {
                LOG.log(Level.FINE, "Could not decode exception {0}: {1}", new Object[]{error, ex});
            }
        }
        return null;
    }

    private static byte[] getData(ReefServiceProtos.RuntimeErrorProto error) {
        return error.hasException() ? error.getException().toByteArray() : null;
    }
}

