/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.Provided;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.Public;
import org.apache.reef.client.ClientConfiguration;
import org.apache.reef.client.CompletedJob;
import org.apache.reef.client.FailedJob;
import org.apache.reef.client.FailedRuntime;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.client.REEF;
import org.apache.reef.client.RunningJob;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;

@Unit
@Public
@Provided
@ClientSide
public final class DriverLauncher {
    private static final Logger LOG = Logger.getLogger(DriverLauncher.class.getName());
    private final REEF reef;
    private LauncherStatus status = LauncherStatus.INIT;
    private RunningJob theJob = null;

    @Inject
    private DriverLauncher(REEF reef) {
        this.reef = reef;
    }

    public static DriverLauncher getLauncher(Configuration runtimeConfiguration) throws BindException, InjectionException {
        Configuration clientConfiguration = ClientConfiguration.CONF.set(ClientConfiguration.ON_JOB_RUNNING, RunningJobHandler.class).set(ClientConfiguration.ON_JOB_COMPLETED, CompletedJobHandler.class).set(ClientConfiguration.ON_JOB_FAILED, FailedJobHandler.class).set(ClientConfiguration.ON_RUNTIME_ERROR, RuntimeErrorHandler.class).build();
        return (DriverLauncher)Tang.Factory.getTang().newInjector(new Configuration[]{runtimeConfiguration, clientConfiguration}).getInstance(DriverLauncher.class);
    }

    public synchronized void close() {
        if (this.status.isRunning()) {
            this.status = LauncherStatus.FORCE_CLOSED;
        }
        if (null != this.theJob) {
            this.theJob.close();
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LauncherStatus run(Configuration driverConfig) {
        this.reef.submit(driverConfig);
        DriverLauncher driverLauncher = this;
        synchronized (driverLauncher) {
            while (!this.status.isDone()) {
                try {
                    LOG.log(Level.FINE, "Wait indefinitely");
                    this.wait();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.FINE, "Interrupted: {0}", ex);
                }
            }
        }
        this.reef.close();
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LauncherStatus run(Configuration driverConfig, long timeOut) {
        long endTime = System.currentTimeMillis() + timeOut;
        this.reef.submit(driverConfig);
        DriverLauncher driverLauncher = this;
        synchronized (driverLauncher) {
            while (!this.status.isDone()) {
                try {
                    long waitTime = endTime - System.currentTimeMillis();
                    if (waitTime <= 0L) break;
                    LOG.log(Level.FINE, "Wait for {0} milliSeconds", waitTime);
                    this.wait(waitTime);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.FINE, "Interrupted: {0}", ex);
                }
            }
            if (System.currentTimeMillis() >= endTime) {
                LOG.log(Level.WARNING, "The Job timed out.");
                this.status = LauncherStatus.FORCE_CLOSED;
            }
        }
        this.reef.close();
        return this.status;
    }

    public LauncherStatus getStatus() {
        return this.status;
    }

    public synchronized void setStatusAndNotify(LauncherStatus status) {
        LOG.log(Level.FINEST, "Set status: {0} -> {1}", new Object[]{this.status, status});
        this.status = status;
        this.notify();
    }

    public String toString() {
        return this.status.toString();
    }

    public final class RuntimeErrorHandler
    implements EventHandler<FailedRuntime> {
        public void onNext(FailedRuntime error) {
            LOG.log(Level.SEVERE, "Received a resourcemanager error", error.getReason());
            DriverLauncher.this.theJob = null;
            DriverLauncher.this.setStatusAndNotify(LauncherStatus.FAILED(error.getReason()));
        }
    }

    public final class CompletedJobHandler
    implements EventHandler<CompletedJob> {
        public void onNext(CompletedJob job) {
            LOG.log(Level.INFO, "The Job {0} is done.", job.getId());
            DriverLauncher.this.theJob = null;
            DriverLauncher.this.setStatusAndNotify(LauncherStatus.COMPLETED);
        }
    }

    public final class FailedJobHandler
    implements EventHandler<FailedJob> {
        public void onNext(FailedJob job) {
            Optional<Throwable> ex = job.getReason();
            LOG.log(Level.SEVERE, "Received an error for job " + job.getId(), ex);
            DriverLauncher.this.theJob = null;
            DriverLauncher.this.setStatusAndNotify(LauncherStatus.FAILED(ex));
        }
    }

    public final class RunningJobHandler
    implements EventHandler<RunningJob> {
        public void onNext(RunningJob job) {
            LOG.log(Level.INFO, "The Job {0} is running.", job.getId());
            DriverLauncher.this.theJob = job;
            DriverLauncher.this.setStatusAndNotify(LauncherStatus.RUNNING);
        }
    }
}

