/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.w3c.service.impl;

import java.io.IOException;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.service.WidgetProviderService;
import org.apache.rave.provider.w3c.service.impl.W3CWidget;
import org.apache.wookie.connector.framework.User;
import org.apache.wookie.connector.framework.WidgetInstance;
import org.apache.wookie.connector.framework.WookieConnectorException;
import org.apache.wookie.connector.framework.WookieConnectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WookieWidgetService
implements WidgetProviderService {
    private static Logger logger = LoggerFactory.getLogger(WookieWidgetService.class);
    private final String wookieServerUrl;
    private final String wookieApiKey;
    private static WookieConnectorService connectorService;

    public WookieWidgetService(String wookieServerUrl, String wookieApiKey) {
        this.wookieServerUrl = wookieServerUrl;
        this.wookieApiKey = wookieApiKey;
    }

    public Widget getWidget(org.apache.rave.portal.model.User viewer, String sharedDataKey, Widget widget) {
        if (widget.getType().equals("W3C")) {
            return this.getWidgetForViewer(widget, sharedDataKey, viewer);
        }
        return null;
    }

    private W3CWidget getWidgetForViewer(Widget widget, String sharedDataKey, org.apache.rave.portal.model.User viewer) {
        try {
            connectorService = this.getWookieConnectorService(this.wookieServerUrl, this.wookieApiKey, sharedDataKey);
            User user = new User(String.valueOf(viewer.getUsername()), viewer.getUsername());
            connectorService.setCurrentUser(user);
            logger.debug("Getting widget:" + widget.getUrl() + " from:" + connectorService.getConnection().getURL());
            WidgetInstance instance = connectorService.getOrCreateInstance(widget.getUrl());
            return this.createWidget(instance);
        }
        catch (WookieConnectorException e) {
            logger.error("Unable to connect to Wookie server", (Throwable)e);
            return this.createWidget(new WidgetInstance("error", "error", e.getMessage(), "100", "100"));
        }
        catch (IOException e) {
            logger.error("Problem communicating with Wookie server", (Throwable)e);
            return this.createWidget(new WidgetInstance("error", "error", e.getMessage(), "100", "100"));
        }
    }

    private W3CWidget createWidget(WidgetInstance instance) {
        W3CWidget widget = new W3CWidget();
        widget.setUrl(instance.getUrl());
        widget.setTitle(instance.getTitle());
        widget.setType("W3C");
        widget.setHeight(Integer.parseInt(instance.getHeight()));
        widget.setWidth(Integer.parseInt(instance.getWidth()));
        return widget;
    }

    private WookieConnectorService getWookieConnectorService(String serverURL, String apiKey, String sharedDataKey) throws WookieConnectorException {
        if (connectorService == null) {
            connectorService = new WookieConnectorService(serverURL, apiKey, sharedDataKey);
        }
        return connectorService;
    }
}

