/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.w3c.web.renderer;

import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.model.RegionWidgetPreference;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetProviderService;
import org.apache.rave.portal.web.renderer.RegionWidgetRenderer;
import org.apache.rave.portal.web.renderer.RenderScope;
import org.apache.rave.portal.web.renderer.ScriptLocation;
import org.apache.rave.portal.web.renderer.ScriptManager;
import org.apache.rave.portal.web.renderer.model.RenderContext;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class W3cWidgetRenderer
implements RegionWidgetRenderer {
    private static Logger logger = LoggerFactory.getLogger(W3cWidgetRenderer.class);
    private final WidgetProviderService widgetService;
    private final UserService userService;
    private ScriptManager scriptManager;
    private static final String SCRIPT_BLOCK = "<script>rave.registerWidget(widgetsByRegionIdMap, %1$s, {type: '%2$s', regionWidgetId: %3$s, widgetUrl: '%4$s',  collapsed: %5$s});</script>";
    private static final String MARKUP = "<!-- RegionWidget %1$s placeholder -->";

    @Autowired
    public W3cWidgetRenderer(@Qualifier(value="wookieWidgetService") WidgetProviderService widgetService, UserService userService, ScriptManager scriptManager) {
        this.widgetService = widgetService;
        this.userService = userService;
        this.scriptManager = scriptManager;
    }

    public String getSupportedContext() {
        return "W3C";
    }

    public String render(RegionWidget item, RenderContext context) {
        Widget widget = item.getWidget();
        if (!"W3C".equals(widget.getType())) {
            throw new NotSupportedException("Invalid widget type passed to renderer: " + widget.getType());
        }
        String widgetScript = this.getWidgetScript(item);
        this.scriptManager.registerScriptBlock(widgetScript, ScriptLocation.AFTER_RAVE, RenderScope.CURRENT_REQUEST, context);
        logger.debug("Gadget Script Data: " + widgetScript);
        return String.format(MARKUP, item.getEntityId());
    }

    private String getWidgetScript(RegionWidget item) {
        User user = this.userService.getAuthenticatedUser();
        Widget contextualizedWidget = this.widgetService.getWidget(user, null, item.getWidget());
        JSONObject userPrefs = new JSONObject();
        if (item.getPreferences() != null) {
            for (RegionWidgetPreference regionWidgetPreference : item.getPreferences()) {
                try {
                    userPrefs.put(regionWidgetPreference.getName(), (Object)regionWidgetPreference.getValue());
                }
                catch (JSONException e) {
                    logger.error("Exception caught adding preference to JSONObject: " + regionWidgetPreference, (Throwable)e);
                }
            }
        }
        return String.format(SCRIPT_BLOCK, item.getRegion().getEntityId(), "W3C", item.getEntityId(), contextualizedWidget.getUrl(), item.isCollapsed());
    }
}

