/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.w3c.repository.impl;

import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.service.WidgetProviderService;
import org.apache.rave.provider.w3c.repository.W3CWidgetMetadataRepository;
import org.apache.rave.provider.w3c.service.impl.WookieWidgetService;
import org.apache.wookie.connector.framework.WookieConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class WookieWidgetMetadataRepository
implements W3CWidgetMetadataRepository {
    private static Logger logger = LoggerFactory.getLogger(WookieWidgetMetadataRepository.class);
    private WookieWidgetService widgetService;

    @Autowired
    public WookieWidgetMetadataRepository(@Qualifier(value="wookieWidgetService") WidgetProviderService widgetService) {
        this.widgetService = (WookieWidgetService)widgetService;
    }

    @Override
    public Widget getWidgetMetadata(String widgetGuid) {
        try {
            return this.widgetService.getWidget(widgetGuid);
        }
        catch (WookieConnectorException e) {
            throw new IllegalArgumentException("Error occurred while processing response from wookie metadata call", e);
        }
    }

    @Override
    public Widget[] getWidgetMetadata() {
        try {
            return this.widgetService.getWidgets();
        }
        catch (WookieConnectorException e) {
            throw new IllegalArgumentException("Error occurred while processing response from wookie metadata call", e);
        }
    }
}

