/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.dropwizard3;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistriesLoader;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.dropwizard3.Dm3MetricRegistriesImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLoadDm3MetricRegistries {
    @Test
    public void testLoadDm3() {
        MetricRegistries r = MetricRegistriesLoader.load();
        Assertions.assertSame(Dm3MetricRegistriesImpl.class, r.getClass());
    }

    @Test
    public void testAddRemoveReporter() {
        AtomicLong cntr = new AtomicLong(0L);
        MetricRegistries r = Dm3MetricRegistriesImpl.global();
        Consumer<RatisMetricRegistry> reporter = v -> cntr.incrementAndGet();
        Consumer<RatisMetricRegistry> stopReporter = v -> cntr.incrementAndGet();
        r.addReporterRegistration(reporter, stopReporter);
        MetricRegistryInfo info = new MetricRegistryInfo("t1", "t1", "t1", "t1");
        r.create(info);
        Assertions.assertEquals((long)1L, (long)cntr.get());
        r.remove(info);
        Assertions.assertEquals((long)2L, (long)cntr.get());
        r.removeReporterRegistration(reporter, stopReporter);
        r.create(info);
        Assertions.assertEquals((long)2L, (long)cntr.get());
        r.remove(info);
        Assertions.assertEquals((long)2L, (long)cntr.get());
    }
}

