/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.util;

import java.util.ArrayList;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.logservice.util.TestUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestLogServiceProtoUtil {
    @Test
    public void testAppendRequest() {
        LogName name = LogName.of((String)"test");
        ArrayList<byte[]> entries = new ArrayList<byte[]>();
        byte[] e1 = new byte[]{1, 1};
        byte[] e2 = new byte[]{2, 2};
        entries.add(e1);
        entries.add(e2);
        LogServiceProtos.LogServiceRequestProto proto = LogServiceProtoUtil.toAppendEntryLogRequestProto((LogName)name, entries);
        LogServiceProtos.AppendLogEntryRequestProto request = proto.getAppendRequest();
        Assert.assertEquals((Object)name.getName(), (Object)request.getLogName().getName());
        Assert.assertEquals((long)2L, (long)request.getDataCount());
        Assert.assertTrue((boolean)TestUtils.equals(e1, request.getData(0).toByteArray()));
        Assert.assertTrue((boolean)TestUtils.equals(e2, request.getData(1).toByteArray()));
    }

    @Test
    public void testAppendReply() {
        ArrayList<byte[]> entries = new ArrayList<byte[]>();
        byte[] e1 = new byte[]{1, 1};
        byte[] e2 = new byte[]{2, 2};
        entries.add(e1);
        entries.add(e2);
        LogServiceProtos.AppendLogEntryReplyProto proto = LogServiceProtoUtil.toAppendLogReplyProto(null, null);
    }

    @Test
    public void testReadRequest() {
        LogName name = LogName.of((String)"test");
        long start = 100L;
        int total = 5;
        LogServiceProtos.LogServiceRequestProto proto = LogServiceProtoUtil.toReadLogRequestProto((LogName)name, (long)start, (int)total);
        LogServiceProtos.ReadLogRequestProto request = proto.getReadNextQuery();
        Assert.assertEquals((Object)name.getName(), (Object)request.getLogName().getName());
        Assert.assertEquals((long)100L, (long)request.getStartRecordId());
        Assert.assertEquals((long)5L, (long)request.getNumRecords());
    }

    @Test
    public void testReadReply() {
        ArrayList<byte[]> entries = new ArrayList<byte[]>();
        byte[] e1 = new byte[]{1, 1};
        byte[] e2 = new byte[]{2, 2};
        entries.add(e1);
        entries.add(e2);
        LogServiceProtos.ReadLogReplyProto proto = LogServiceProtoUtil.toReadLogReplyProto(entries, null);
        Assert.assertEquals((long)2L, (long)proto.getLogRecordCount());
        Assert.assertTrue((boolean)TestUtils.equals(e1, proto.getLogRecord(0).toByteArray()));
        Assert.assertTrue((boolean)TestUtils.equals(e2, proto.getLogRecord(1).toByteArray()));
    }

    @Test
    public void testGetLengthReply() {
        long len = 100L;
        LogServiceProtos.GetLogLengthReplyProto proto = LogServiceProtoUtil.toGetLogLengthReplyProto((long)len, null);
        Assert.assertEquals((long)len, (long)proto.getLength());
    }

    @Test
    public void testGetLengthRequest() {
        LogName name = LogName.of((String)"test");
        LogServiceProtos.LogServiceRequestProto proto = LogServiceProtoUtil.toGetLengthRequestProto((LogName)name);
        LogServiceProtos.GetLogLengthRequestProto request = proto.getLengthQuery();
        Assert.assertEquals((Object)name.getName(), (Object)request.getLogName().getName());
    }

    @Test
    public void testGetStartIndexRequest() {
        LogName name = LogName.of((String)"test");
        LogServiceProtos.LogServiceRequestProto proto = LogServiceProtoUtil.toGetStartIndexProto((LogName)name);
        LogServiceProtos.GetLogStartIndexRequestProto request = proto.getStartIndexQuery();
        Assert.assertEquals((Object)name.getName(), (Object)request.getLogName().getName());
    }

    @Test
    public void testGetStartIndexReply() {
        long index = 100L;
        LogServiceProtos.GetLogStartIndexReplyProto proto = LogServiceProtoUtil.toGetLogStartIndexReplyProto((long)index, null);
        Assert.assertEquals((long)index, (long)proto.getStartIndex());
    }

    @Test
    public void testSyncRequest() {
        LogName name = LogName.of((String)"test");
        LogServiceProtos.LogServiceRequestProto proto = LogServiceProtoUtil.toSyncLogRequestProto((LogName)name);
        LogServiceProtos.SyncLogRequestProto request = proto.getSyncRequest();
        Assert.assertEquals((Object)name.getName(), (Object)request.getLogName().getName());
    }

    @Test
    public void testSyncReply() {
        LogServiceProtos.SyncLogReplyProto proto = LogServiceProtoUtil.toSyncLogReplyProto((long)0L, null);
    }

    @Test
    public void testListLogsReply() {
    }

    @Test
    public void testGetStateRequest() {
        LogName name = LogName.of((String)"test");
        LogServiceProtos.LogServiceRequestProto proto = LogServiceProtoUtil.toGetStateRequestProto((LogName)name);
        LogServiceProtos.GetStateRequestProto request = proto.getGetState();
        Assert.assertEquals((Object)name.getName(), (Object)request.getLogName().getName());
    }

    @Test
    @Ignore
    public void testGetStateReply() {
        Object logStream = null;
        LogServiceProtos.GetStateReplyProto proto = LogServiceProtoUtil.toGetStateReplyProto((LogStream.State)LogStream.State.OPEN);
    }

    @Test
    public void testCloseLogRequest() {
        LogName name = LogName.of((String)"test");
        LogServiceProtos.LogServiceRequestProto proto = LogServiceProtoUtil.toChangeStateRequestProto((LogName)name, (LogStream.State)LogStream.State.CLOSED);
        LogServiceProtos.ChangeStateLogRequestProto request = proto.getChangeState();
        Assert.assertEquals((Object)name.getName(), (Object)request.getLogName().getName());
    }
}

