/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ratis.BaseTest;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogServiceClient;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.server.LogServer;
import org.apache.ratis.logservice.server.MetadataServer;

public class LogServiceCluster
implements AutoCloseable {
    private List<MetadataServer> masters;
    private List<LogServer> workers = new ArrayList<LogServer>();
    private String baseTestDir = BaseTest.getRootTestDir().getAbsolutePath();

    public void createWorkers(int numWorkers) {
        String meta = this.getMetaIdentity();
        List newWorkers = IntStream.range(0, numWorkers).parallel().mapToObj(i -> (LogServer)LogServer.newBuilder().setHostName("localhost").setPort(10000 + i).setMetaQuorum(meta).setWorkingDir(this.baseTestDir + "/workers/" + i).build()).collect(Collectors.toList());
        newWorkers.parallelStream().forEach(worker -> {
            try {
                worker.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.workers.addAll(newWorkers);
    }

    public String getMetaIdentity() {
        return this.masters.stream().map(object -> object.getAddress()).collect(Collectors.joining(","));
    }

    public LogServiceCluster(int numServers) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < numServers; ++i2) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("localhost:").append(9000 + i2);
        }
        String metaQuorum = sb.toString();
        this.masters = IntStream.range(0, numServers).parallel().mapToObj(i -> (MetadataServer)MetadataServer.newBuilder().setHostName("localhost").setPort(9000 + i).setWorkingDir(this.baseTestDir + "/masters/" + i).setMetaQuorum(metaQuorum).build()).collect(Collectors.toList());
        this.masters.parallelStream().forEach(master -> {
            try {
                master.cleanUp();
                master.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public LogStream createLog(LogName logName) throws Exception {
        try (LogServiceClient client = new LogServiceClient(this.getMetaIdentity());){
            LogStream logStream = client.createLog(logName);
            return logStream;
        }
    }

    public List<LogServer> getWorkers() {
        return this.workers;
    }

    public List<MetadataServer> getMasters() {
        return this.masters;
    }

    @Override
    public void close() {
        ((Stream)this.masters.stream().parallel()).forEach(master -> {
            try {
                master.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        ((Stream)this.workers.stream().parallel()).forEach(worker -> {
            try {
                worker.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public LogStream getLog(LogName logName) throws Exception {
        try (LogServiceClient client = new LogServiceClient(this.getMetaIdentity());){
            LogStream logStream = client.getLog(logName);
            return logStream;
        }
    }

    public void cleanUp() {
    }
}

