/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.tool;

import java.nio.ByteBuffer;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogServiceClient;
import org.apache.ratis.logservice.tool.VerificationTool;
import org.junit.Assert;
import org.junit.Test;

public class TestVerificationTool {
    VerificationTool.Operation createOp(int valueSize) {
        return new MockOperation(null, null, 1, 1, valueSize);
    }

    @Test
    public void testValueSerialization() {
        for (int i = 0; i < 50; ++i) {
            VerificationTool.Operation op = this.createOp(i);
            String value = "message" + i;
            ByteBuffer serialized = op.createValue(value);
            Assert.assertEquals((long)i, (long)(serialized.limit() - serialized.arrayOffset()));
            Assert.assertEquals((Object)value.substring(0, Math.min(i, value.length())), (Object)op.parseValue(serialized));
        }
    }

    private static class MockOperation
    extends VerificationTool.Operation {
        MockOperation(LogName logName, LogServiceClient client, int numRecords, int logFreq, int valueSize) {
            super(logName, client, numRecords, logFreq, valueSize);
        }

        public void run() {
            throw new UnsupportedOperationException();
        }
    }
}

