/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.apache.ratis.logservice.api.LogInfo;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogReader;
import org.apache.ratis.logservice.api.LogServiceClient;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.api.LogWriter;
import org.apache.ratis.logservice.common.LogAlreadyExistException;
import org.apache.ratis.logservice.common.LogNotFoundException;
import org.apache.ratis.logservice.metrics.LogServiceMetricsRegistry;
import org.apache.ratis.logservice.proto.MetaServiceProtos;
import org.apache.ratis.logservice.server.ArchivalInfo;
import org.apache.ratis.logservice.server.LogServer;
import org.apache.ratis.logservice.server.MetaStateMachine;
import org.apache.ratis.logservice.server.MetadataServer;
import org.apache.ratis.logservice.util.LogServiceCluster;
import org.apache.ratis.logservice.util.TestUtils;
import org.apache.ratis.metrics.JVMMetrics;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.util.TimeDuration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestMetaServer {
    static LogServiceCluster cluster;
    static List<LogServer> workers;
    static AtomicInteger createCount;
    static AtomicInteger deleteCount;
    static AtomicInteger listCount;
    LogServiceClient client = new LogServiceClient(cluster.getMetaIdentity()){

        public LogStream createLog(LogName logName) throws IOException {
            createCount.incrementAndGet();
            return super.createLog(logName);
        }

        public void deleteLog(LogName logName) throws IOException {
            deleteCount.incrementAndGet();
            super.deleteLog(logName);
        }

        public List<LogInfo> listLogs() throws IOException {
            listCount.incrementAndGet();
            return super.listLogs();
        }
    };

    @BeforeClass
    public static void beforeClass() {
        cluster = new LogServiceCluster(3);
        cluster.createWorkers(3);
        workers = cluster.getWorkers();
        assert (workers.size() == 3);
    }

    @AfterClass
    public static void afterClass() {
        if (cluster != null) {
            cluster.close();
        }
    }

    @Test
    public void testCreateAndGetLog() throws Exception {
        LogStream logStream1 = this.client.createLog(LogName.of((String)"testCreateLog"));
        Assert.assertNotNull((Object)logStream1);
        LogStream logStream2 = this.client.getLog(LogName.of((String)"testCreateLog"));
        Assert.assertNotNull((Object)logStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseLogOnNodeFailure() throws Exception {
        boolean peerClosed = false;
        try {
            int i;
            for (i = 0; i < 5; ++i) {
                LogStream logStream1 = this.client.createLog(LogName.of((String)("testCloseLogOnNodeFailure" + i)));
                Assert.assertNotNull((Object)logStream1);
            }
            Assert.assertTrue((boolean)((MetaStateMachine)cluster.getMasters().get(0).getMetaStateMachine()).checkPeersAreSame());
            workers.get(0).close();
            peerClosed = true;
            Thread.sleep(90000L);
            Assert.assertTrue((boolean)((MetaStateMachine)cluster.getMasters().get(0).getMetaStateMachine()).checkPeersAreSame());
            for (i = 0; i < 5; ++i) {
                LogStream logStream2 = this.client.getLog(LogName.of((String)("testCloseLogOnNodeFailure" + i)));
                Assert.assertNotNull((Object)logStream2);
                Assert.assertEquals((Object)LogStream.State.CLOSED, (Object)logStream2.getState());
            }
        }
        finally {
            if (peerClosed) {
                cluster.createWorkers(1);
            }
        }
    }

    @Test
    public void testReadWritetoLog() throws IOException, InterruptedException {
        RaftServerImpl raftServerImpl;
        LogStream stream = this.client.createLog(LogName.of((String)"testReadWrite"));
        LogWriter writer = stream.createWriter();
        ByteBuffer testMessage = ByteBuffer.wrap("Hello world!".getBytes());
        List listLogs = this.client.listLogs();
        assert (listLogs.stream().filter(log -> log.getLogName().getName().startsWith("testReadWrite")).count() == 1L);
        List<LogServer> workers = cluster.getWorkers();
        for (LogServer worker : workers) {
            raftServerImpl = ((RaftServerProxy)worker.getServer()).getImpl(((LogInfo)listLogs.get(0)).getRaftGroup().getGroupId());
        }
        writer.write(testMessage);
        for (LogServer worker : workers) {
            raftServerImpl = ((RaftServerProxy)worker.getServer()).getImpl(((LogInfo)listLogs.get(0)).getRaftGroup().getGroupId());
        }
        LogReader reader = stream.createReader();
        ByteBuffer res = reader.readNext();
        assert (res.array().length > 0);
    }

    @Test
    public void testLogArchival() throws IOException, InterruptedException {
        LogName logName = LogName.of((String)"testArchivalLog");
        LogStream logStream = this.client.createLog(logName);
        LogWriter writer = logStream.createWriter();
        List listLogs = this.client.listLogs();
        assert (listLogs.stream().filter(log -> log.getLogName().getName().startsWith(logName.getName())).count() == 1L);
        List<LogServer> workers = cluster.getWorkers();
        List<ByteBuffer> records = TestUtils.getRandomData(100, 10);
        writer.write(records);
        this.client.closeLog(logName);
        Assert.assertEquals((Object)logStream.getState(), (Object)LogStream.State.CLOSED);
        this.client.archiveLog(logName);
        for (int retry = 0; logStream.getState() != LogStream.State.ARCHIVED && retry <= 40; ++retry) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((Object)logStream.getState(), (Object)LogStream.State.ARCHIVED);
        LogReader reader = logStream.createReader();
        List data = reader.readBulk(records.size());
        Assert.assertEquals((long)records.size(), (long)data.size());
        reader.seek(1L);
        data = reader.readBulk(records.size());
        Assert.assertEquals((long)(records.size() - 1), (long)data.size());
        LogServiceConfiguration config = LogServiceConfiguration.create();
        LogStream archiveLogStream = this.client.getArchivedLog(logName);
        reader = archiveLogStream.createReader();
        data = reader.readBulk(records.size());
        Assert.assertEquals((long)records.size(), (long)data.size());
    }

    @Test
    public void testLogExport() throws IOException, InterruptedException {
        LogName logName = LogName.of((String)"testLogExport");
        LogStream logStream = this.client.createLog(logName);
        LogWriter writer = logStream.createWriter();
        List listLogs = this.client.listLogs();
        assert (listLogs.stream().filter(log -> log.getLogName().getName().startsWith(logName.getName())).count() == 1L);
        List<LogServer> workers = cluster.getWorkers();
        List<ByteBuffer> records = TestUtils.getRandomData(100, 10);
        writer.write(records);
        String location1 = "target/tmp/export_1/";
        String location2 = "target/tmp/export_2/";
        this.deleteLocalDirectory(new File(location1));
        this.deleteLocalDirectory(new File(location2));
        int startPosition1 = 3;
        int startPosition2 = 5;
        this.client.exportLog(logName, location1, (long)startPosition1);
        this.client.exportLog(logName, location2, (long)startPosition2);
        List infos = this.client.getExportStatus(logName);
        for (int count = 0; infos.size() > 1 && (((ArchivalInfo)infos.get(0)).getStatus() != ArchivalInfo.ArchivalStatus.COMPLETED || ((ArchivalInfo)infos.get(1)).getStatus() != ArchivalInfo.ArchivalStatus.COMPLETED) && count < 10; ++count) {
            infos = this.client.getExportStatus(logName);
            Thread.sleep(1000L);
        }
        LogStream exportLogStream = this.client.getExportLog(logName, location1);
        LogReader reader = exportLogStream.createReader();
        List data = reader.readBulk(records.size());
        Assert.assertEquals((long)(records.size() - startPosition1), (long)data.size());
        reader.close();
        exportLogStream = this.client.getExportLog(logName, location2);
        reader = exportLogStream.createReader();
        data = reader.readBulk(records.size());
        Assert.assertEquals((long)(records.size() - startPosition2), (long)data.size());
        reader.close();
        writer.close();
    }

    boolean deleteLocalDirectory(File dir) {
        File[] allFiles = dir.listFiles();
        if (allFiles != null) {
            for (File file : allFiles) {
                this.deleteLocalDirectory(file);
            }
        }
        return dir.delete();
    }

    @Test
    public void testDeleteLog() throws Exception {
        block2: {
            LogStream logStream1 = this.client.createLog(LogName.of((String)"testDeleteLog"));
            Assert.assertNotNull((Object)logStream1);
            this.client.deleteLog(LogName.of((String)"testDeleteLog"));
            this.testJMXCount(MetaServiceProtos.MetaServiceRequestProto.TypeCase.DELETELOG.name(), Long.valueOf(deleteCount.get()));
            try {
                logStream1 = this.client.getLog(LogName.of((String)"testDeleteLog"));
                Assert.fail((String)"Failed to throw LogNotFoundException");
            }
            catch (Exception e) {
                if ($assertionsDisabled || e instanceof LogNotFoundException) break block2;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testGetNotExistingLog() {
        block2: {
            try {
                LogStream log = this.client.getLog(LogName.of((String)"no_such_log"));
                Assert.fail((String)"LogNotFoundException was not thrown");
            }
            catch (IOException e) {
                if ($assertionsDisabled || e instanceof LogNotFoundException) break block2;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testAlreadyExistLog() throws Exception {
        block2: {
            LogStream logStream1 = this.client.createLog(LogName.of((String)"test1"));
            Assert.assertNotNull((Object)logStream1);
            try {
                logStream1 = this.client.createLog(LogName.of((String)"test1"));
                Assert.fail((String)"Didn't fail with LogAlreadyExistException");
            }
            catch (IOException e) {
                if ($assertionsDisabled || e instanceof LogAlreadyExistException) break block2;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testListLogs() throws Exception {
        this.client.createLog(LogName.of((String)"listLogTest1"));
        this.client.createLog(LogName.of((String)"listLogTest2"));
        this.client.createLog(LogName.of((String)"listLogTest3"));
        this.client.createLog(LogName.of((String)"listLogTest4"));
        this.client.createLog(LogName.of((String)"listLogTest5"));
        this.client.createLog(LogName.of((String)"listLogTest6"));
        this.client.createLog(LogName.of((String)"listLogTest7"));
        List list = this.client.listLogs();
        this.testJMXCount(MetaServiceProtos.MetaServiceRequestProto.TypeCase.CREATELOG.name(), Long.valueOf(createCount.get()));
        this.testJMXCount(MetaServiceProtos.MetaServiceRequestProto.TypeCase.LISTLOGS.name(), listCount.longValue());
        assert (list.stream().filter(log -> log.getLogName().getName().startsWith("listLogTest")).count() == 7L);
    }

    private void testJMXCount(String metricName, Long expectedCount) throws Exception {
        Assert.assertEquals((Object)expectedCount, (Object)this.getJMXCount(metricName));
    }

    private Long getJMXCount(String metricName) throws Exception {
        for (MetadataServer master : cluster.getMasters()) {
            ObjectName oname = new ObjectName("ratis_log_service", "name", LogServiceMetricsRegistry.getMetricRegistryForLogServiceMetaData((String)master.getId()).getMetricRegistryInfo().getName() + "." + metricName);
            try {
                return (Long)ManagementFactory.getPlatformMBeanServer().getAttribute(oname, "Count");
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
        }
        throw new InstanceNotFoundException();
    }

    @Ignore(value="Too heavy for the current implementation")
    @Test
    public void testFinalClieanUp() throws Exception {
        IntStream.range(0, 10).forEach(i -> {
            try {
                this.client.createLog(LogName.of((String)("CleanTest" + i)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        List list = this.client.listLogs();
        list.parallelStream().forEach(loginfo -> {
            try {
                this.client.deleteLog(loginfo.getLogName());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        list = this.client.listLogs();
        assert (list.size() == 0);
    }

    static {
        JVMMetrics.initJvmMetrics((TimeDuration)TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS));
        cluster = null;
        workers = null;
        createCount = new AtomicInteger();
        deleteCount = new AtomicInteger();
        listCount = new AtomicInteger();
    }
}

