/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.server.BaseServer;
import org.apache.ratis.logservice.server.ServerOpts;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.junit.Test;

public class TestBaseServer {
    @Test
    public void testDefaultPropertiesAreValid() {
        RaftProperties props = new RaftProperties();
        try (MockServer server = new MockServer();){
            server.validateRaftProperties(props);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testAutoSnapshotIsInvalid() {
        RaftProperties props = new RaftProperties();
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)props, (boolean)true);
        try (MockServer server = new MockServer();){
            server.validateRaftProperties(props);
        }
    }

    private static class MockServer
    extends BaseServer {
        public MockServer() {
            super(new ServerOpts());
        }

        public void close() {
        }
    }
}

