/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.impl;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.ratis.logservice.api.ArchiveLogReader;
import org.apache.ratis.logservice.api.ArchiveLogWriter;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.impl.ArchiveHdfsLogReader;
import org.apache.ratis.logservice.impl.ArchiveHdfsLogWriter;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestArchiveHdfsLogReaderAndWriter {
    static MiniDFSCluster cluster;
    static Configuration conf;
    private static String location;

    @BeforeClass
    public static void setup() throws IOException {
        conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        location = "target/tmp/archive/TestArchiveHdfsLogReaderAndWriter";
    }

    @Test
    public void testRollingWriter() throws IOException {
        String archiveLocation = location + "/testRollingWriter";
        LogName logName = LogName.of((String)"testRollingWriterLogName");
        DistributedFileSystem fs = cluster.getFileSystem();
        fs.delete(new Path(archiveLocation), true);
        ArchiveHdfsLogWriter writer = new ArchiveHdfsLogWriter(conf);
        writer.init(archiveLocation, logName);
        int k = 2;
        this.write((ArchiveLogWriter)writer, 1, k);
        Assert.assertEquals((long)writer.getLastWrittenRecordId(), (long)k);
        writer.rollWriter();
        Object[] files = (String[])Arrays.stream(fs.listStatus(new Path(LogServiceUtils.getArchiveLocationForLog((String)archiveLocation, (LogName)logName)))).map(fileStatus -> fileStatus.getPath().getName()).toArray(String[]::new);
        Object[] expectedFiles = new String[]{logName.getName(), logName.getName() + "_recordId_" + k};
        Assert.assertArrayEquals((Object[])expectedFiles, (Object[])files);
        ArchiveHdfsLogReader reader = new ArchiveHdfsLogReader(conf, LogServiceUtils.getArchiveLocationForLog((String)archiveLocation, (LogName)logName));
        this.verifyRecords((ArchiveLogReader)reader, k);
        Assert.assertEquals((long)writer.getLastWrittenRecordId(), (long)reader.getPosition());
        this.write((ArchiveLogWriter)writer, k + 1, 2 * k);
        Assert.assertEquals((long)writer.getLastWrittenRecordId(), (long)(2 * k));
        writer.close();
        reader = new ArchiveHdfsLogReader(conf, LogServiceUtils.getArchiveLocationForLog((String)archiveLocation, (LogName)logName));
        this.verifyRecords((ArchiveLogReader)reader, 2 * k);
        files = (String[])reader.getFiles().stream().map(fileStatus -> fileStatus.getPath().getName()).toArray(String[]::new);
        Object[] expectedFiles1 = new String[]{logName.getName() + "_recordId_" + k, logName.getName() + "_recordId_" + 2 * k};
        Assert.assertArrayEquals((Object[])expectedFiles1, (Object[])files);
        reader.close();
    }

    private void verifyRecords(ArchiveLogReader reader, int n) throws IOException {
        for (int i = 1; i <= n; ++i) {
            Assert.assertEquals((long)i, (long)ByteBuffer.wrap(reader.next()).getInt());
        }
        Assert.assertFalse((boolean)reader.hasNext());
        Assert.assertTrue((reader.next() == null ? 1 : 0) != 0);
        try {
            reader.readNext();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void write(ArchiveLogWriter writer, int start, int end) throws IOException {
        Integer i = start;
        while (i <= end) {
            writer.write(ByteBuffer.allocate(4).putInt(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    @Test
    public void testCorruptedFileEOF() throws IOException {
        FSDataOutputStream fos = FileSystem.get((Configuration)conf).create(new Path(location, "testEOF"));
        fos.write(ByteBuffer.allocate(4).putInt(4).array());
        fos.write(new byte[4]);
        fos.write(ByteBuffer.allocate(4).putInt(4).array());
        fos.write(new byte[2]);
        fos.close();
        ArchiveHdfsLogReader reader = new ArchiveHdfsLogReader(conf, location + "/testEOF");
        try {
            reader.next();
            Assert.fail();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    public void testSeek() throws IOException {
        String archiveLocation = location + "/testSeek";
        LogName logName = LogName.of((String)"testSeek");
        DistributedFileSystem fs = cluster.getFileSystem();
        fs.delete(new Path(archiveLocation), true);
        ArchiveHdfsLogWriter writer = new ArchiveHdfsLogWriter(conf);
        writer.init(archiveLocation, logName);
        int k = 100;
        this.write((ArchiveLogWriter)writer, 1, k);
        writer.close();
        ArchiveHdfsLogReader reader = new ArchiveHdfsLogReader(conf, LogServiceUtils.getArchiveLocationForLog((String)archiveLocation, (LogName)logName));
        reader.seek(80L);
        Assert.assertEquals((long)80L, (long)reader.getPosition());
        int count = 0;
        while (reader.next() != null) {
            ++count;
        }
        Assert.assertEquals((long)20L, (long)count);
    }

    @AfterClass
    public static void teardownafterclass() {
        if (cluster != null) {
            cluster.shutdown();
        }
        TestArchiveHdfsLogReaderAndWriter.deleteLocalDirectory(new File(location));
    }

    static boolean deleteLocalDirectory(File dir) {
        File[] allFiles = dir.listFiles();
        if (allFiles != null) {
            for (File file : allFiles) {
                TestArchiveHdfsLogReaderAndWriter.deleteLocalDirectory(file);
            }
        }
        return dir.delete();
    }
}

