/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.management.ObjectName;
import org.apache.ratis.BaseTest;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogReader;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.api.LogWriter;
import org.apache.ratis.logservice.impl.LogStreamImpl;
import org.apache.ratis.logservice.metrics.LogServiceMetricsRegistry;
import org.apache.ratis.logservice.server.LogStateMachine;
import org.apache.ratis.logservice.util.TestUtils;
import org.apache.ratis.metrics.JVMMetrics;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.TimeDuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogServiceReadWriteBase<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final Logger LOG = LoggerFactory.getLogger(LogServiceReadWriteBase.class);
    static final int NUM_PEERS = 3;
    CLUSTER cluster;

    public LogServiceReadWriteBase() {
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, LogStateMachine.class, StateMachine.class);
        LOG.info("Set LogStateMachine OK");
    }

    @Before
    public void setUpCluster() throws IOException, InterruptedException {
        RaftProperties raftProperties = this.getProperties();
        this.cluster = this.getFactory().newCluster(3, raftProperties);
        this.cluster.start();
        RaftTestUtil.waitForLeader(this.cluster);
    }

    @Test
    public void testLogServiceReadWrite() throws Exception {
        RaftClient raftClient = RaftClient.newBuilder().setProperties(this.getProperties()).setRaftGroup(this.cluster.getGroup()).build();
        LogName logName = LogName.of((String)"log1");
        try (MetricLogStream logStream = new MetricLogStream(logName, raftClient);){
            Assert.assertEquals((Object)"log1", (Object)logStream.getName().getName());
            Assert.assertEquals((Object)LogStream.State.OPEN, (Object)logStream.getState());
            Assert.assertEquals((long)0L, (long)logStream.getSize());
            Assert.assertEquals((long)0L, (long)logStream.getLength());
            this.testJMXMetrics((LogStream)logStream);
            LogReader reader = logStream.createReader();
            LogWriter writer = logStream.createWriter();
            long lastId = logStream.getLastRecordId();
            LOG.info("last id {}", (Object)lastId);
            List<ByteBuffer> records = TestUtils.getRandomData(100, 10);
            List ids = writer.write(records);
            LOG.info("ids {}", (Object)ids);
            Assert.assertEquals((long)1000L, (long)logStream.getSize());
            Assert.assertEquals((long)10L, (long)logStream.getLength());
            long lastId2 = logStream.getLastRecordId();
            LOG.info("last id {}", (Object)lastId2);
            long startId = logStream.getStartRecordId();
            LOG.info("start id {}", (Object)startId);
            reader.seek(startId);
            List data = reader.readBulk(records.size());
            Assert.assertEquals((long)records.size(), (long)data.size());
            Iterator<ByteBuffer> expectedIter = records.iterator();
            Iterator actualIter = data.iterator();
            while (expectedIter.hasNext() && actualIter.hasNext()) {
                ByteBuffer expected = expectedIter.next();
                ByteBuffer actual = (ByteBuffer)actualIter.next();
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            this.testJMXMetrics((LogStream)logStream);
            Assert.assertEquals((Object)logStream.getState(), (Object)LogStream.State.OPEN);
        }
    }

    @Test
    public void testReadAllRecords() throws Exception {
        RaftClient raftClient = RaftClient.newBuilder().setProperties(this.getProperties()).setRaftGroup(this.cluster.getGroup()).build();
        LogName logName = LogName.of((String)"log1");
        int numRecords = 25;
        try (MetricLogStream logStream = new MetricLogStream(logName, raftClient);){
            int i;
            try (LogWriter writer = logStream.createWriter();){
                LOG.info("Writing {} records", (Object)25);
                for (i = 0; i < 25; ++i) {
                    writer.write(this.toBytes(i));
                }
            }
            var7_9 = null;
            try (LogReader reader = logStream.createReader();){
                reader.seek(0L);
                for (i = 0; i < 25; ++i) {
                    Assert.assertEquals((long)i, (long)this.fromBytes(reader.readNext()));
                }
                reader.seek(0L);
                List records = reader.readBulk(25);
                Assert.assertEquals((long)25L, (long)records.size());
                for (int i2 = 0; i2 < 25; ++i2) {
                    ByteBuffer record = (ByteBuffer)records.get(i2);
                    Assert.assertEquals((long)i2, (long)this.fromBytes(record));
                }
                reader.seek(0L);
                ByteBuffer[] arr = new ByteBuffer[25];
                reader.readBulk(arr);
                for (int i3 = 0; i3 < 25; ++i3) {
                    Assert.assertEquals((long)i3, (long)this.fromBytes(arr[i3]));
                }
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testSeeking() throws Exception {
        RaftClient raftClient = RaftClient.newBuilder().setProperties(this.getProperties()).setRaftGroup(this.cluster.getGroup()).build();
        LogName logName = LogName.of((String)"log1");
        int numRecords = 100;
        try (MetricLogStream logStream = new MetricLogStream(logName, raftClient);){
            int i;
            try (LogWriter writer = logStream.createWriter();){
                LOG.info("Writing {} records", (Object)100);
                for (i = 0; i < 100; ++i) {
                    writer.write(this.toBytes(i));
                }
            }
            LOG.debug("Seek and read'ing records");
            var7_9 = null;
            try (LogReader reader = logStream.createReader();){
                for (i = 9; i < 100; i += 10) {
                    LOG.info("Seeking to {}", (Object)i);
                    reader.seek((long)i);
                    LOG.info("Reading one record");
                    Assert.assertEquals((long)i, (long)this.fromBytes(reader.readNext()));
                }
                Assert.assertTrue((String)"We're expecting at least two records were written", (boolean)true);
                for (i = 98; i >= 0; i -= 6) {
                    LOG.info("Seeking to {}", (Object)i);
                    reader.seek((long)i);
                    LOG.info("Reading one record");
                    Assert.assertEquals((long)i, (long)this.fromBytes(reader.readNext()));
                }
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testSeekFromWrite() throws Exception {
        RaftClient raftClient = RaftClient.newBuilder().setProperties(this.getProperties()).setRaftGroup(this.cluster.getGroup()).build();
        LogName logName = LogName.of((String)"log1");
        int numRecords = 10;
        try (MetricLogStream logStream = new MetricLogStream(logName, raftClient);){
            ArrayList<Long> recordIds;
            try (LogWriter writer = logStream.createWriter();){
                int i;
                LOG.info("Writing {} records", (Object)10);
                ArrayList<ByteBuffer> records = new ArrayList<ByteBuffer>(20);
                for (i = 0; i < 10; ++i) {
                    records.add(this.toBytes(i));
                }
                recordIds = new ArrayList<Long>(writer.write(records));
                for (i = 10; i < 20; ++i) {
                    recordIds.add(writer.write(this.toBytes(i)));
                }
            }
            Assert.assertEquals((long)20L, (long)recordIds.size());
            Assert.assertEquals(LongStream.range(0L, 20L).boxed().collect(Collectors.toList()), recordIds);
            var8_7 = null;
            try (LogReader reader = logStream.createReader();){
                int i = 0;
                Iterator iterator = recordIds.iterator();
                while (iterator.hasNext()) {
                    long recordId = (Long)iterator.next();
                    reader.seek(recordId);
                    int readValue = this.fromBytes(reader.readNext());
                    Assert.assertEquals((String)("Seeked to " + recordId + " but got " + readValue), (long)i++, (long)readValue);
                }
            }
            catch (Throwable throwable) {
                var8_7 = throwable;
                throw throwable;
            }
        }
    }

    @After
    public void tearDown() {
        this.cluster.shutdown();
    }

    private ByteBuffer toBytes(int i) {
        return ByteBuffer.wrap(Integer.toString(i).getBytes(StandardCharsets.UTF_8));
    }

    private int fromBytes(ByteBuffer bb) {
        byte[] bytes = new byte[bb.remaining()];
        System.arraycopy(bb.array(), bb.arrayOffset(), bytes, 0, bb.remaining());
        return Integer.parseInt(new String(bytes, StandardCharsets.UTF_8));
    }

    private void testJMXMetrics(LogStream logStream) throws Exception {
        Assert.assertEquals((Object)((MetricLogStream)logStream).getLengthCount, (Object)this.getJMXCount(this.cluster.getGroup().getGroupId().toString(), "lengthQueryTime"));
        Assert.assertEquals((Object)((MetricLogStream)logStream).getSizeCount, (Object)this.getJMXCount(this.cluster.getGroup().getGroupId().toString(), "sizeRequestTime"));
    }

    private Long getJMXCount(String groupId, String metricName) throws Exception {
        ObjectName oname = new ObjectName("ratis_log_service", "name", LogServiceMetricsRegistry.getMetricRegistryForLogService((String)groupId, (String)this.cluster.getLeader().getId().toString()).getMetricRegistryInfo().getName() + "." + metricName);
        return (Long)ManagementFactory.getPlatformMBeanServer().getAttribute(oname, "Count");
    }

    static {
        JVMMetrics.initJvmMetrics((TimeDuration)TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS));
    }

    class MetricLogStream
    extends LogStreamImpl {
        Long startRecordIdCount;
        Long getStateCount;
        Long getLastRecordIdCount;
        Long getLengthCount;
        Long getSizeCount;

        public MetricLogStream(LogName name, RaftClient raftClient) {
            super(name, raftClient);
            this.startRecordIdCount = 0L;
            this.getStateCount = 0L;
            this.getLastRecordIdCount = 0L;
            this.getLengthCount = 0L;
            this.getSizeCount = 0L;
        }

        public long getStartRecordId() throws IOException {
            Long l = this.startRecordIdCount;
            Long l2 = this.startRecordIdCount = Long.valueOf(this.startRecordIdCount + 1L);
            return super.getStartRecordId();
        }

        public LogStream.State getState() throws IOException {
            Long l = this.getStateCount;
            Long l2 = this.getStateCount = Long.valueOf(this.getStateCount + 1L);
            return super.getState();
        }

        public long getLastRecordId() throws IOException {
            Long l = this.getLastRecordIdCount;
            Long l2 = this.getLastRecordIdCount = Long.valueOf(this.getLastRecordIdCount + 1L);
            return super.getLastRecordId();
        }

        public long getLength() throws IOException {
            Long l = this.getLengthCount;
            Long l2 = this.getLengthCount = Long.valueOf(this.getLengthCount + 1L);
            return super.getLength();
        }

        public long getSize() throws IOException {
            Long l = this.getSizeCount;
            Long l2 = this.getSizeCount = Long.valueOf(this.getSizeCount + 1L);
            return super.getSize();
        }

        public LogName getName() {
            return super.getName();
        }
    }
}

