/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.usergroupsync;

import org.apache.log4j.Logger;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usergroupsync.UserGroupSource;

public class UserGroupSync
implements Runnable {
    private static final Logger LOG = Logger.getLogger(UserGroupSync.class);
    private boolean shutdownFlag = false;
    private UserGroupSink ugSink = null;
    private UserGroupSource ugSource = null;

    public static void main(String[] args) {
        UserGroupSync userGroupSync = new UserGroupSync();
        userGroupSync.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long sleepTimeBetweenCycleInMillis = UserGroupSyncConfig.getInstance().getSleepTimeInMillisBetweenCycle();
            boolean initDone = false;
            while (!initDone) {
                try {
                    this.ugSink = UserGroupSyncConfig.getInstance().getUserGroupSink();
                    LOG.info((Object)("initializing sink: " + this.ugSink.getClass().getName()));
                    this.ugSink.init();
                    this.ugSource = UserGroupSyncConfig.getInstance().getUserGroupSource();
                    LOG.info((Object)("initializing source: " + this.ugSource.getClass().getName()));
                    this.ugSource.init();
                    LOG.info((Object)"Begin: initial load of user/group from source==>sink");
                    this.ugSource.updateSink(this.ugSink);
                    LOG.info((Object)"End: initial load of user/group from source==>sink");
                    initDone = true;
                    LOG.info((Object)"Done initializing user/group source and sink");
                }
                catch (Throwable t) {
                    LOG.error((Object)("Failed to initialize UserGroup source/sink. Will retry after " + sleepTimeBetweenCycleInMillis + " milliseconds. Error details: "), t);
                    try {
                        LOG.debug((Object)("Sleeping for [" + sleepTimeBetweenCycleInMillis + "] milliSeconds"));
                        Thread.sleep(sleepTimeBetweenCycleInMillis);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to wait for [" + sleepTimeBetweenCycleInMillis + "] milliseconds before attempting to initialize UserGroup source/sink"), (Throwable)e);
                    }
                }
            }
            boolean forceSync = false;
            while (!this.shutdownFlag) {
                try {
                    LOG.debug((Object)("Sleeping for [" + sleepTimeBetweenCycleInMillis + "] milliSeconds"));
                    Thread.sleep(sleepTimeBetweenCycleInMillis);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)("Failed to wait for [" + sleepTimeBetweenCycleInMillis + "] milliseconds before attempting to synchronize UserGroup information"), (Throwable)e);
                }
                try {
                    this.syncUserGroup(forceSync);
                    forceSync = false;
                }
                catch (Throwable t) {
                    LOG.error((Object)"Failed to synchronize UserGroup information. Error details: ", t);
                    forceSync = true;
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"UserGroupSync thread got an error", t);
        }
        finally {
            LOG.error((Object)"Shutting down the UserGroupSync thread");
        }
    }

    private void syncUserGroup(boolean forceSync) throws Throwable {
        UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
        try {
            if (config.isUserSyncEnabled()) {
                if (forceSync || this.ugSource.isChanged()) {
                    LOG.info((Object)"Begin: update user/group from source==>sink");
                    this.ugSource.updateSink(this.ugSink);
                    LOG.info((Object)"End: update user/group from source==>sink");
                } else {
                    LOG.debug((Object)"UserGroupSource: no change found for synchronization.");
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to sync user/group : ", t);
        }
    }
}

