/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.process;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usergroupsync.UserGroupSource;

public class UnixUserGroupBuilder
implements UserGroupSource {
    private static final Logger LOG = Logger.getLogger(UnixUserGroupBuilder.class);
    private static final String OS = System.getProperty("os.name");
    public static final String UNIX_USER_PASSWORD_FILE = "/etc/passwd";
    public static final String UNIX_GROUP_FILE = "/etc/group";
    static final String LINUX_GET_ALL_USERS_CMD = "getent passwd";
    static final String LINUX_GET_ALL_GROUPS_CMD = "getent group";
    static final String LINUX_GET_GROUP_CMD = "getent group %s";
    static final String MAC_GET_ALL_USERS_CMD = "dscl . -readall /Users UniqueID PrimaryGroupID | awk 'BEGIN { OFS = \":\"; ORS=\"\\n\"; i=0;}/RecordName: / {name = $2;i = 0;}/PrimaryGroupID: / {gid = $2;}/^ / {if (i == 0) { i++; name = $1;}}/UniqueID: / {uid = $2;print name, \"*\", gid, uid;}'";
    static final String MAC_GET_ALL_GROUPS_CMD = "dscl . -list /Groups PrimaryGroupID | awk -v OFS=\":\" '{print $1, \"*\", $2, \"\"}'";
    static final String MAC_GET_GROUP_CMD = "dscl . -read /Groups/%1$s | paste -d, -s - | sed -e 's/:/|/g' | awk -v OFS=\":\" -v ORS=\"\\n\" -F, '{print \"%1$s\",\"*\",$6,$4}' | sed -e 's/:[^:]*| /:/g' | sed -e 's/ /,/g'";
    static final String BACKEND_PASSWD = "passwd";
    private boolean enumerateGroupMembers = false;
    private boolean useNss = false;
    private long lastUpdateTime = 0L;
    private long timeout = 0L;
    private UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
    private Map<String, List<String>> user2GroupListMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> internalUser2GroupListMap = new HashMap<String, List<String>>();
    private Map<String, String> groupId2groupNameMap = new HashMap<String, String>();
    private int minimumUserId = Integer.parseInt(this.config.getMinUserId());
    private int minimumGroupId = Integer.parseInt(this.config.getMinGroupId());
    private long passwordFileModifiedAt = 0L;
    private long groupFileModifiedAt = 0L;

    public static void main(String[] args) throws Throwable {
        UnixUserGroupBuilder ugbuilder = new UnixUserGroupBuilder();
        ugbuilder.init();
        ugbuilder.print();
    }

    public UnixUserGroupBuilder() {
        LOG.debug((Object)("Minimum UserId: " + this.minimumUserId + ", minimum GroupId: " + this.minimumGroupId));
        this.timeout = this.config.getUpdateMillisMin();
        this.enumerateGroupMembers = this.config.isGroupEnumerateEnabled();
        if (!this.config.getUnixBackend().equalsIgnoreCase(BACKEND_PASSWD)) {
            this.useNss = true;
        } else {
            LOG.warn((Object)"DEPRECATED: Unix backend is configured to use /etc/passwd and /etc/group files directly instead of standard system mechanisms.");
        }
    }

    @Override
    public void init() throws Throwable {
        this.buildUserGroupInfo();
    }

    @Override
    public boolean isChanged() {
        if (this.useNss) {
            return System.currentTimeMillis() - this.lastUpdateTime > this.timeout;
        }
        long TempPasswordFileModifiedAt = new File(UNIX_USER_PASSWORD_FILE).lastModified();
        if (this.passwordFileModifiedAt != TempPasswordFileModifiedAt) {
            return true;
        }
        long TempGroupFileModifiedAt = new File(UNIX_GROUP_FILE).lastModified();
        return this.groupFileModifiedAt != TempGroupFileModifiedAt;
    }

    @Override
    public void updateSink(UserGroupSink sink) throws Throwable {
        this.buildUserGroupInfo();
        for (Map.Entry<String, List<String>> entry : this.user2GroupListMap.entrySet()) {
            String user = entry.getKey();
            List<String> groups = entry.getValue();
            try {
                sink.addOrUpdateUser(user, groups);
            }
            catch (Throwable t) {
                LOG.error((Object)("sink.addOrUpdateUser failed with exception: " + t.getMessage() + ", for user: " + user + ", groups: " + groups));
            }
        }
    }

    private void buildUserGroupInfo() throws Throwable {
        this.user2GroupListMap = new HashMap<String, List<String>>();
        this.groupId2groupNameMap = new HashMap<String, String>();
        if (OS.startsWith("Mac")) {
            this.buildUnixGroupList(MAC_GET_ALL_GROUPS_CMD, MAC_GET_GROUP_CMD, false);
            this.buildUnixUserList(MAC_GET_ALL_USERS_CMD);
        } else {
            if (!OS.startsWith("Linux")) {
                LOG.warn((Object)"Platform not recognized assuming Linux compatible");
            }
            this.buildUnixGroupList(LINUX_GET_ALL_GROUPS_CMD, LINUX_GET_GROUP_CMD, true);
            this.buildUnixUserList(LINUX_GET_ALL_USERS_CMD);
        }
        this.lastUpdateTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            this.print();
        }
    }

    private void print() {
        for (String user : this.user2GroupListMap.keySet()) {
            LOG.debug((Object)("USER:" + user));
            List<String> groups = this.user2GroupListMap.get(user);
            if (groups == null) continue;
            for (String group : groups) {
                LOG.debug((Object)("\tGROUP: " + group));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildUnixUserList(String command) throws Throwable {
        String line;
        HashMap<String, String> userName2uid = new HashMap<String, String>();
        try (BufferedReader reader = null;){
            if (!this.useNss) {
                File file = new File(UNIX_USER_PASSWORD_FILE);
                this.passwordFileModifiedAt = file.lastModified();
                FileInputStream fis = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            } else {
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command});
                reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            }
            line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                String[] tokens = line.split(":");
                int len = tokens.length;
                if (len < 3) {
                    LOG.warn((Object)("Unable to parse: " + line));
                    continue;
                }
                String userName = null;
                String userId = null;
                String groupId = null;
                try {
                    userName = tokens[0];
                    userId = tokens[2];
                    groupId = tokens[3];
                }
                catch (ArrayIndexOutOfBoundsException aiobe) {
                    LOG.warn((Object)("Ignoring line - [" + line + "]: Unable to parse line for getting user information"), (Throwable)aiobe);
                    continue;
                }
                int numUserId = -1;
                try {
                    numUserId = Integer.parseInt(userId);
                }
                catch (NumberFormatException nfe) {
                    LOG.warn((Object)("Unix UserId: [" + userId + "]: can not be parsed as valid int. considering as  -1."), (Throwable)nfe);
                    numUserId = -1;
                }
                if (numUserId >= this.minimumUserId) {
                    userName2uid.put(userName, userId);
                    String groupName = this.groupId2groupNameMap.get(groupId);
                    if (groupName != null) {
                        ArrayList<String> groupList = new ArrayList<String>();
                        groupList.add(groupName);
                        if (this.internalUser2GroupListMap.containsKey(userName)) {
                            List<String> map = this.internalUser2GroupListMap.get(userName);
                            map.remove(groupName);
                            groupList.addAll(map);
                        }
                        this.user2GroupListMap.put(userName, groupList);
                        continue;
                    }
                    LOG.warn((Object)("Group Name could not be found for group id: [" + groupId + "]. Skipping adding user [" + userName + "] with id [" + userId + "]."));
                    continue;
                }
                LOG.debug((Object)("Skipping user [" + userName + "] since its userid [" + userId + "] is less than minuserid limit [" + this.minimumUserId + "]."));
            }
        }
        if (!this.useNss) {
            return;
        }
        if (this.enumerateGroupMembers) {
            line = null;
            LOG.debug((Object)"Start drill down group members");
            for (Map.Entry<String, List<String>> entry : this.internalUser2GroupListMap.entrySet()) {
                if (this.user2GroupListMap.containsKey(entry.getKey())) continue;
                LOG.debug((Object)("Enumerating user " + entry.getKey()));
                int numUserId = -1;
                try {
                    numUserId = Integer.parseInt((String)userName2uid.get(entry.getKey()));
                }
                catch (NumberFormatException nfe) {
                    numUserId = -1;
                }
                if (numUserId < this.minimumUserId && numUserId != -1) continue;
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", "id -G " + entry.getKey()});
                try {
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    line = reader.readLine();
                }
                finally {
                    reader.close();
                }
                LOG.debug((Object)("id -G returned " + line));
                if (line == null || line.trim().isEmpty()) {
                    LOG.warn((Object)("User " + entry.getKey() + " could not be resolved"));
                    continue;
                }
                String[] gids = line.split(" ");
                ArrayList<String> allowedGroups = new ArrayList<String>();
                for (String gid : gids) {
                    String groupName;
                    int numGroupId = Integer.parseInt(gid);
                    if (numGroupId < this.minimumGroupId || (groupName = this.groupId2groupNameMap.get(gid)) == null) continue;
                    allowedGroups.add(groupName);
                }
                this.user2GroupListMap.put(entry.getKey(), allowedGroups);
            }
            LOG.debug((Object)"End drill down group members");
        }
    }

    private void parseMembers(String line) {
        int numGroupId;
        if (line == null || line.isEmpty()) {
            return;
        }
        String[] tokens = line.split(":");
        if (tokens.length < 2) {
            return;
        }
        String groupName = tokens[0];
        String groupId = tokens[2];
        String groupMembers = null;
        if (tokens.length > 3) {
            groupMembers = tokens[3];
        }
        if (this.groupId2groupNameMap.containsKey(groupId)) {
            this.groupId2groupNameMap.remove(groupId);
        }
        if ((numGroupId = Integer.parseInt(groupId)) < this.minimumGroupId) {
            return;
        }
        this.groupId2groupNameMap.put(groupId, groupName);
        if (groupMembers != null && !groupMembers.trim().isEmpty()) {
            for (String user : groupMembers.split(",")) {
                List<String> groupList = this.internalUser2GroupListMap.get(user);
                if (groupList == null) {
                    groupList = new ArrayList<String>();
                    this.internalUser2GroupListMap.put(user, groupList);
                }
                if (groupList.contains(groupName)) continue;
                groupList.add(groupName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildUnixGroupList(String allGroupsCmd, String groupCmd, boolean useGid) throws Throwable {
        String line;
        LOG.debug((Object)"Start enumerating groups");
        try (BufferedReader reader = null;){
            if (!this.useNss) {
                File file = new File(UNIX_GROUP_FILE);
                this.groupFileModifiedAt = file.lastModified();
                FileInputStream fis = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            } else {
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", allGroupsCmd});
                reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            }
            line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                this.parseMembers(line);
            }
        }
        LOG.debug((Object)"End enumerating group");
        if (!this.useNss) {
            return;
        }
        if (this.enumerateGroupMembers) {
            LOG.debug((Object)"Start enumerating group members");
            line = null;
            HashMap<String, String> copy = new HashMap<String, String>(this.groupId2groupNameMap);
            for (Map.Entry entry : copy.entrySet()) {
                LOG.debug((Object)("Enumerating group: " + (String)entry.getValue() + " GID(" + (String)entry.getKey() + ")"));
                String command = useGid ? String.format(groupCmd, entry.getKey()) : String.format(groupCmd, entry.getValue());
                Object[] cmd = new String[]{"bash", "-c", command + " " + (String)entry.getKey()};
                LOG.debug((Object)("Executing: " + Arrays.toString(cmd)));
                try {
                    Process process = Runtime.getRuntime().exec((String[])cmd);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    line = reader.readLine();
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                LOG.debug((Object)("bash -c " + command + " for group " + entry + " returned " + line));
                this.parseMembers(line);
            }
            LOG.debug((Object)"End enumerating group members");
        }
        if (this.config.getEnumerateGroups() != null) {
            line = null;
            String[] groups = this.config.getEnumerateGroups().split(",");
            LOG.debug((Object)"Adding extra groups");
            for (String group : groups) {
                String command = String.format(groupCmd, group);
                Object[] cmd = new String[]{"bash", "-c", command + " '" + group + "'"};
                LOG.debug((Object)("Executing: " + Arrays.toString(cmd)));
                try {
                    Process process = Runtime.getRuntime().exec((String[])cmd);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    line = reader.readLine();
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                LOG.debug((Object)("bash -c " + command + " for group " + group + " returned " + line));
                this.parseMembers(line);
            }
            LOG.debug((Object)"Done adding extra groups");
        }
    }

    @VisibleForTesting
    Map<String, List<String>> getUser2GroupListMap() {
        return this.user2GroupListMap;
    }

    @VisibleForTesting
    Map<String, String> getGroupId2groupNameMap() {
        return this.groupId2groupNameMap;
    }
}

