/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.process;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.AbstractUserGroupSource;
import org.apache.ranger.usergroupsync.UserGroupSink;

public class FileSourceUserGroupBuilder
extends AbstractUserGroupSource {
    private static final Logger LOG = Logger.getLogger(FileSourceUserGroupBuilder.class);
    private Map<String, List<String>> user2GroupListMap = new HashMap<String, List<String>>();
    private String userGroupFilename = null;
    private long usergroupFileModified = 0L;

    public static void main(String[] args) throws Throwable {
        FileSourceUserGroupBuilder filesourceUGBuilder = new FileSourceUserGroupBuilder();
        if (args.length > 0) {
            filesourceUGBuilder.setUserGroupFilename(args[0]);
        }
        filesourceUGBuilder.init();
        UserGroupSink ugSink = UserGroupSyncConfig.getInstance().getUserGroupSink();
        LOG.info((Object)("initializing sink: " + ugSink.getClass().getName()));
        ugSink.init();
        filesourceUGBuilder.updateSink(ugSink);
        if (LOG.isDebugEnabled()) {
            filesourceUGBuilder.print();
        }
    }

    @Override
    public void init() throws Throwable {
        if (this.userGroupFilename == null) {
            this.userGroupFilename = this.config.getUserSyncFileSource();
        }
        this.buildUserGroupInfo();
    }

    @Override
    public boolean isChanged() {
        long TempUserGroupFileModifedAt = new File(this.userGroupFilename).lastModified();
        return this.usergroupFileModified != TempUserGroupFileModifedAt;
    }

    @Override
    public void updateSink(UserGroupSink sink) throws Throwable {
        this.buildUserGroupInfo();
        String user = null;
        List<String> groups = null;
        for (Map.Entry<String, List<String>> entry : this.user2GroupListMap.entrySet()) {
            user = entry.getKey();
            try {
                if (this.userNameRegExInst != null) {
                    user = this.userNameRegExInst.transform(user);
                }
                groups = entry.getValue();
                if (this.groupNameRegExInst != null) {
                    ArrayList<String> mappedGroups = new ArrayList<String>();
                    for (String group : groups) {
                        mappedGroups.add(this.groupNameRegExInst.transform(group));
                    }
                    groups = mappedGroups;
                }
                sink.addOrUpdateUser(user, groups);
            }
            catch (Throwable t) {
                LOG.error((Object)("sink.addOrUpdateUser failed with exception: " + t.getMessage() + ", for user: " + user + ", groups: " + groups));
            }
        }
    }

    private void setUserGroupFilename(String filename) {
        this.userGroupFilename = filename;
    }

    private void print() {
        for (String user : this.user2GroupListMap.keySet()) {
            LOG.debug((Object)("USER:" + user));
            List<String> groups = this.user2GroupListMap.get(user);
            if (groups == null) continue;
            for (String group : groups) {
                LOG.debug((Object)("\tGROUP: " + group));
            }
        }
    }

    public void buildUserGroupInfo() throws Throwable {
        this.buildUserGroupList();
        if (LOG.isDebugEnabled()) {
            this.print();
        }
    }

    public void buildUserGroupList() throws Throwable {
        if (this.userGroupFilename == null) {
            throw new Exception("User Group Source File is not Configured. Please maintain in unixauthservice.properties or pass it as command line argument for org.apache.ranger.unixusersync.process.FileSourceUserGroupBuilder");
        }
        File f = new File(this.userGroupFilename);
        if (f.exists() && f.canRead()) {
            Map<String, List<String>> tmpUser2GroupListMap = null;
            tmpUser2GroupListMap = this.isJsonFile(this.userGroupFilename) ? this.readJSONfile(f) : this.readTextFile(f);
            if (tmpUser2GroupListMap != null) {
                this.user2GroupListMap = tmpUser2GroupListMap;
                this.usergroupFileModified = f.lastModified();
            } else {
                LOG.info((Object)"No new UserGroup to sync at this time");
            }
        } else {
            throw new Exception("User Group Source File " + this.userGroupFilename + "doesn't not exist or readable");
        }
    }

    public boolean isJsonFile(String userGroupFilename) {
        boolean ret = false;
        if (userGroupFilename.toLowerCase().endsWith(".json")) {
            ret = true;
        }
        return ret;
    }

    public Map<String, List<String>> readJSONfile(File jsonFile) throws Exception {
        HashMap<String, List<String>> ret = new HashMap();
        JsonReader jsonReader = new JsonReader((Reader)new BufferedReader(new FileReader(jsonFile)));
        Gson gson = new GsonBuilder().create();
        ret = (Map)gson.fromJson(jsonReader, ret.getClass());
        return ret;
    }

    public Map<String, List<String>> readTextFile(File textFile) throws Exception {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        String delimiter = this.config.getUserSyncFileSourceDelimiter();
        CSVFormat csvFormat = CSVFormat.newFormat((char)delimiter.charAt(0));
        CSVParser csvParser = new CSVParser((Reader)new BufferedReader(new FileReader(textFile)), csvFormat);
        List csvRecordList = csvParser.getRecords();
        if (csvRecordList != null) {
            for (CSVRecord csvRecord : csvRecordList) {
                ArrayList<String> groups = new ArrayList<String>();
                String user = csvRecord.get(0);
                user = user.replaceAll("^\"|\"$", "");
                int i = csvRecord.size();
                for (int j = 1; j < i; ++j) {
                    String group = csvRecord.get(j);
                    if (group == null || group.isEmpty()) continue;
                    group = group.replaceAll("^\"|\"$", "");
                    groups.add(group);
                }
                ret.put(user, groups);
            }
        }
        csvParser.close();
        return ret;
    }
}

